/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class TicketStorage
extends SavedData {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Pair<ChunkPos, Ticket>> TICKET_ENTRY = Codec.mapPair((MapCodec)ChunkPos.CODEC.fieldOf("chunk_pos"), Ticket.CODEC).codec();
    public static final Codec<TicketStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TICKET_ENTRY.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::packTickets)).apply((Applicative)instance, TicketStorage::fromPacked));
    public static final SavedDataType<TicketStorage> TYPE = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, CODEC, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    public final Long2ObjectOpenHashMap<List<Ticket>> tickets;
    private final Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    private LongSet chunksWithForcedTickets = new LongOpenHashSet();
    @Nullable
    private ChunkUpdated loadingChunkUpdatedListener;
    @Nullable
    private ChunkUpdated simulationChunkUpdatedListener;

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap, Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap1) {
        this.tickets = long2objectopenhashmap;
        this.deactivatedTickets = long2objectopenhashmap1;
        this.updateForcedChunks();
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage fromPacked(List<Pair<ChunkPos, Ticket>> list) {
        Long2ObjectOpenHashMap long2objectopenhashmap = new Long2ObjectOpenHashMap();
        for (Pair<ChunkPos, Ticket> pair : list) {
            ChunkPos chunkcoordintpair = (ChunkPos)pair.getFirst();
            List list1 = (List)long2objectopenhashmap.computeIfAbsent(chunkcoordintpair.toLong(), i -> new ObjectArrayList(4));
            list1.add((Ticket)pair.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)long2objectopenhashmap);
    }

    private List<Pair<ChunkPos, Ticket>> packTickets() {
        ArrayList<Pair<ChunkPos, Ticket>> list = new ArrayList<Pair<ChunkPos, Ticket>>();
        this.forEachTicket((chunkcoordintpair, ticket) -> {
            if (ticket.getType().persist()) {
                list.add(new Pair(chunkcoordintpair, ticket));
            }
        });
        return list;
    }

    private void forEachTicket(BiConsumer<ChunkPos, Ticket> biconsumer) {
        TicketStorage.forEachTicket(biconsumer, this.tickets);
        TicketStorage.forEachTicket(biconsumer, this.deactivatedTickets);
    }

    private static void forEachTicket(BiConsumer<ChunkPos, Ticket> biconsumer, Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap) {
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(long2objectopenhashmap)) {
            ChunkPos chunkcoordintpair = new ChunkPos(long2objectmap_entry.getLongKey());
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                biconsumer.accept(chunkcoordintpair, ticket);
            }
        }
    }

    public void activateAllDeactivatedTickets() {
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.deactivatedTickets)) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                this.addTicket(long2objectmap_entry.getLongKey(), ticket);
            }
        }
        this.deactivatedTickets.clear();
    }

    public void setLoadingChunkUpdatedListener(@Nullable ChunkUpdated ticketstorage_a) {
        this.loadingChunkUpdatedListener = ticketstorage_a;
    }

    public void setSimulationChunkUpdatedListener(@Nullable ChunkUpdated ticketstorage_a) {
        this.simulationChunkUpdatedListener = ticketstorage_a;
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    public boolean shouldKeepDimensionActive() {
        for (List list : this.tickets.values()) {
            for (Ticket ticket : list) {
                if (!ticket.getType().shouldKeepDimensionActive()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Ticket> getTickets(long i) {
        return (List)this.tickets.getOrDefault(i, List.of());
    }

    private List<Ticket> getOrCreateTickets(long i) {
        return (List)this.tickets.computeIfAbsent(i, j -> new ObjectArrayList(4));
    }

    public void addTicketWithRadius(TicketType tickettype, ChunkPos chunkcoordintpair, int i) {
        Ticket ticket = new Ticket(tickettype, ChunkLevel.byStatus(FullChunkStatus.FULL) - i);
        this.addTicket(chunkcoordintpair.toLong(), ticket);
    }

    public void addTicket(Ticket ticket, ChunkPos chunkcoordintpair) {
        this.addTicket(chunkcoordintpair.toLong(), ticket);
    }

    public boolean addTicket(long i, Ticket ticket) {
        List<Ticket> list = this.getOrCreateTickets(i);
        for (Ticket ticket1 : list) {
            if (!TicketStorage.isTicketSameTypeAndLevel(ticket, ticket1)) continue;
            ticket1.resetTicksLeft();
            this.setDirty();
            return false;
        }
        int j = TicketStorage.getTicketLevelAt(list, true);
        int k = TicketStorage.getTicketLevelAt(list, false);
        list.add(ticket);
        if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
            LOGGER.debug("ATI {} {}", (Object)new ChunkPos(i), (Object)ticket);
        }
        if (ticket.getType().doesSimulate() && ticket.getTicketLevel() < j && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(i, ticket.getTicketLevel(), true);
        }
        if (ticket.getType().doesLoad() && ticket.getTicketLevel() < k && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(i, ticket.getTicketLevel(), true);
        }
        if (ticket.getType().equals(TicketType.FORCED)) {
            this.chunksWithForcedTickets.add(i);
        }
        this.setDirty();
        return true;
    }

    private static boolean isTicketSameTypeAndLevel(Ticket ticket, Ticket ticket1) {
        return ticket1.getType() == ticket.getType() && ticket1.getTicketLevel() == ticket.getTicketLevel() && Objects.equals(ticket.key, ticket1.key);
    }

    public int getTicketLevelAt(long i, boolean flag) {
        return TicketStorage.getTicketLevelAt(this.getTickets(i), flag);
    }

    private static int getTicketLevelAt(List<Ticket> list, boolean flag) {
        Ticket ticket = TicketStorage.getLowestTicket(list, flag);
        return ticket == null ? ChunkLevel.MAX_LEVEL + 1 : ticket.getTicketLevel();
    }

    @Nullable
    private static Ticket getLowestTicket(@Nullable List<Ticket> list, boolean flag) {
        if (list == null) {
            return null;
        }
        Ticket ticket = null;
        for (Ticket ticket1 : list) {
            if (ticket != null && ticket1.getTicketLevel() >= ticket.getTicketLevel()) continue;
            if (flag && ticket1.getType().doesSimulate()) {
                ticket = ticket1;
                continue;
            }
            if (flag || !ticket1.getType().doesLoad()) continue;
            ticket = ticket1;
        }
        return ticket;
    }

    public void removeTicketWithRadius(TicketType tickettype, ChunkPos chunkcoordintpair, int i) {
        Ticket ticket = new Ticket(tickettype, ChunkLevel.byStatus(FullChunkStatus.FULL) - i);
        this.removeTicket(chunkcoordintpair.toLong(), ticket);
    }

    public void removeTicket(Ticket ticket, ChunkPos chunkcoordintpair) {
        this.removeTicket(chunkcoordintpair.toLong(), ticket);
    }

    public boolean removeTicket(long i, Ticket ticket) {
        List list = (List)this.tickets.get(i);
        if (list == null) {
            return false;
        }
        boolean flag = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ticket ticket1 = (Ticket)iterator.next();
            if (!TicketStorage.isTicketSameTypeAndLevel(ticket, ticket1)) continue;
            iterator.remove();
            if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
                LOGGER.debug("RTI {} {}", (Object)new ChunkPos(i), (Object)ticket1);
            }
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        if (list.isEmpty()) {
            this.tickets.remove(i);
        }
        if (ticket.getType().doesSimulate() && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(i, TicketStorage.getTicketLevelAt(list, true), false);
        }
        if (ticket.getType().doesLoad() && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(i, TicketStorage.getTicketLevelAt(list, false), false);
        }
        if (ticket.getType().equals(TicketType.FORCED)) {
            this.updateForcedChunks();
        }
        this.setDirty();
        return true;
    }

    private void updateForcedChunks() {
        this.chunksWithForcedTickets = this.getAllChunksWithTicketThat(ticket -> ticket.getType().equals(TicketType.FORCED));
    }

    public String getTicketDebugString(long i, boolean flag) {
        List<Ticket> list = this.getTickets(i);
        Ticket ticket = TicketStorage.getLowestTicket(list, flag);
        return ticket == null ? "no_ticket" : ticket.toString();
    }

    public void purgeStaleTickets(ChunkMap playerchunkmap) {
        this.removeTicketIf((ticket, i) -> {
            if (this.canTicketExpire(playerchunkmap, ticket, i)) {
                ticket.decreaseTicksLeft();
                return ticket.isTimedOut();
            }
            return false;
        }, (Long2ObjectOpenHashMap<List<Ticket>>)((Long2ObjectOpenHashMap)null));
        this.setDirty();
    }

    private boolean canTicketExpire(ChunkMap playerchunkmap, Ticket ticket, long i) {
        if (!ticket.getType().hasTimeout()) {
            return false;
        }
        if (ticket.getType().canExpireIfUnloaded()) {
            return true;
        }
        ChunkHolder playerchunk = playerchunkmap.getUpdatingChunkIfPresent(i);
        return playerchunk == null || playerchunk.isReadyForSaving();
    }

    public void deactivateTicketsOnClosing() {
        this.removeTicketIf((ticket, i) -> ticket.getType() != TicketType.UNKNOWN, this.deactivatedTickets);
    }

    public void removeTicketIf(TicketPredicate ticketstorage_b, @Nullable Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap) {
        ObjectIterator objectiterator = this.tickets.long2ObjectEntrySet().fastIterator();
        boolean flag = false;
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry long2objectmap_entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((List)long2objectmap_entry.getValue()).iterator();
            long i = long2objectmap_entry.getLongKey();
            boolean flag1 = false;
            boolean flag2 = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticketstorage_b.test(ticket, i)) continue;
                if (long2objectopenhashmap != null) {
                    List list = (List)long2objectopenhashmap.computeIfAbsent(i, j -> new ObjectArrayList(((List)long2objectmap_entry.getValue()).size()));
                    list.add(ticket);
                }
                iterator.remove();
                if (ticket.getType().doesLoad()) {
                    flag2 = true;
                }
                if (ticket.getType().doesSimulate()) {
                    flag1 = true;
                }
                if (!ticket.getType().equals(TicketType.FORCED)) continue;
                flag = true;
            }
            if (!flag2 && !flag1) continue;
            if (flag2 && this.loadingChunkUpdatedListener != null) {
                this.loadingChunkUpdatedListener.update(i, TicketStorage.getTicketLevelAt((List)long2objectmap_entry.getValue(), false), false);
            }
            if (flag1 && this.simulationChunkUpdatedListener != null) {
                this.simulationChunkUpdatedListener.update(i, TicketStorage.getTicketLevelAt((List)long2objectmap_entry.getValue(), true), false);
            }
            this.setDirty();
            if (!((List)long2objectmap_entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
        if (flag) {
            this.updateForcedChunks();
        }
    }

    public void replaceTicketLevelOfType(int i, TicketType tickettype) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry long2objectmap_entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                if (ticket.getType() != tickettype) continue;
                list.add(Pair.of((Object)ticket, (Object)long2objectmap_entry.getLongKey()));
            }
        }
        for (Pair pair : list) {
            Long olong = (Long)pair.getSecond();
            Ticket ticket1 = (Ticket)pair.getFirst();
            this.removeTicket(olong, ticket1);
            TicketType tickettype1 = ticket1.getType();
            this.addTicket(olong, new Ticket(tickettype1, i));
        }
    }

    public boolean updateChunkForced(ChunkPos chunkcoordintpair, boolean flag) {
        Ticket ticket = new Ticket(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL);
        return flag ? this.addTicket(chunkcoordintpair.toLong(), ticket) : this.removeTicket(chunkcoordintpair.toLong(), ticket);
    }

    public LongSet getForceLoadedChunks() {
        return this.chunksWithForcedTickets;
    }

    private LongSet getAllChunksWithTicketThat(Predicate<Ticket> predicate) {
        LongOpenHashSet longopenhashset = new LongOpenHashSet();
        block0: for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.tickets)) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                if (!predicate.test(ticket)) continue;
                longopenhashset.add(long2objectmap_entry.getLongKey());
                continue block0;
            }
        }
        return longopenhashset;
    }

    @FunctionalInterface
    public static interface ChunkUpdated {
        public void update(long var1, int var3, boolean var4);
    }

    public static interface TicketPredicate {
        public boolean test(Ticket var1, long var2);
    }
}

