/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BaseFireBlock
extends Block {
    private static final int SECONDS_ON_FIRE = 8;
    private static final int MIN_FIRE_TICKS_TO_ADD = 1;
    private static final int MAX_FIRE_TICKS_TO_ADD = 3;
    private final float fireDamage;
    protected static final VoxelShape SHAPE = Block.column(16.0, 0.0, 1.0);

    public BaseFireBlock(BlockBehaviour.Properties blockbase_info, float f) {
        super(blockbase_info);
        this.fireDamage = f;
    }

    protected abstract MapCodec<? extends BaseFireBlock> codec();

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return BaseFireBlock.getState(blockactioncontext.getLevel(), blockactioncontext.getClickedPos());
    }

    public static BlockState getState(BlockGetter iblockaccess, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.below();
        BlockState iblockdata = iblockaccess.getBlockState(blockposition1);
        return SoulFireBlock.canSurviveOnBlock(iblockdata) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).getStateForPlacement(iblockaccess, blockposition);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        block12: {
            block11: {
                BlockPos blockposition1;
                BlockState iblockdata1;
                if (randomsource.nextInt(24) == 0) {
                    world.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + randomsource.nextFloat(), randomsource.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(iblockdata1 = world.getBlockState(blockposition1 = blockposition.below())) || iblockdata1.isFaceSturdy(world, blockposition1, Direction.UP)) break block11;
                if (this.canBurn(world.getBlockState(blockposition.west()))) {
                    for (int i = 0; i < 2; ++i) {
                        double d0 = (double)blockposition.getX() + randomsource.nextDouble() * (double)0.1f;
                        double d1 = (double)blockposition.getY() + randomsource.nextDouble();
                        double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(blockposition.east()))) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)(blockposition.getX() + 1) - randomsource.nextDouble() * (double)0.1f;
                        double d4 = (double)blockposition.getY() + randomsource.nextDouble();
                        double d5 = (double)blockposition.getZ() + randomsource.nextDouble();
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d3, d4, d5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(blockposition.north()))) {
                    for (int k = 0; k < 2; ++k) {
                        double d6 = (double)blockposition.getX() + randomsource.nextDouble();
                        double d7 = (double)blockposition.getY() + randomsource.nextDouble();
                        double d8 = (double)blockposition.getZ() + randomsource.nextDouble() * (double)0.1f;
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d6, d7, d8, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(blockposition.south()))) {
                    for (int l = 0; l < 2; ++l) {
                        double d9 = (double)blockposition.getX() + randomsource.nextDouble();
                        double d10 = (double)blockposition.getY() + randomsource.nextDouble();
                        double d11 = (double)(blockposition.getZ() + 1) - randomsource.nextDouble() * (double)0.1f;
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d9, d10, d11, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(world.getBlockState(blockposition.above()))) break block12;
                for (int i1 = 0; i1 < 2; ++i1) {
                    double d12 = (double)blockposition.getX() + randomsource.nextDouble();
                    double d13 = (double)(blockposition.getY() + 1) - randomsource.nextDouble() * (double)0.1f;
                    double d14 = (double)blockposition.getZ() + randomsource.nextDouble();
                    world.addParticle(ParticleTypes.LARGE_SMOKE, d12, d13, d14, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int j1 = 0; j1 < 3; ++j1) {
                double d15 = (double)blockposition.getX() + randomsource.nextDouble();
                double d16 = (double)blockposition.getY() + randomsource.nextDouble() * 0.5 + 0.5;
                double d17 = (double)blockposition.getZ() + randomsource.nextDouble();
                world.addParticle(ParticleTypes.LARGE_SMOKE, d15, d16, d17, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean canBurn(BlockState var1);

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        insideblockeffectapplier.apply(InsideBlockEffectType.CLEAR_FREEZE);
        insideblockeffectapplier.apply(InsideBlockEffectType.FIRE_IGNITE);
        insideblockeffectapplier.runAfter(InsideBlockEffectType.FIRE_IGNITE, entity1 -> entity1.hurt(entity1.level().damageSources().inFire(), this.fireDamage));
    }

    public static void fireIgnite(net.minecraft.world.entity.Entity entity) {
        if (!entity.fireImmune()) {
            if (entity.getRemainingFireTicks() < 0) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
            } else if (entity instanceof ServerPlayer) {
                int i = entity.level().getRandom().nextInt(1, 3);
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + i);
            }
            if (entity.getRemainingFireTicks() >= 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent(entity.getBukkitEntity().getLocation().getBlock(), (Entity)entity.getBukkitEntity(), 8.0f);
                entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag, UseOnContext context) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            Optional<PortalShape> optional;
            if (BaseFireBlock.inPortalDimension(world) && (optional = PortalShape.findEmptyPortalShape(world, blockposition, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks(world, context == null ? null : context.getPlayer());
                return;
            }
            if (!iblockdata.canSurvive(world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean inPortalDimension(Level world) {
        return world.getTypeKey() == LevelStem.OVERWORLD || world.getTypeKey() == LevelStem.NETHER;
    }

    @Override
    protected void spawnDestroyParticles(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata) {
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (!world.isClientSide()) {
            world.levelEvent(null, 1009, blockposition, 0);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    public static boolean canBePlacedAt(Level world, BlockPos blockposition, Direction enumdirection) {
        BlockState iblockdata = world.getBlockState(blockposition);
        return !iblockdata.isAir() ? false : BaseFireBlock.getState(world, blockposition).canSurvive(world, blockposition) || BaseFireBlock.isPortal(world, blockposition, enumdirection);
    }

    private static boolean isPortal(Level world, BlockPos blockposition, Direction enumdirection) {
        if (!BaseFireBlock.inPortalDimension(world)) {
            return false;
        }
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        boolean flag = false;
        for (Direction enumdirection1 : Direction.values()) {
            if (!world.getBlockState(blockposition_mutableblockposition.set(blockposition).move(enumdirection1)).is(Blocks.OBSIDIAN)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis().isHorizontal() ? enumdirection.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(world.random);
        return PortalShape.findEmptyPortalShape(world, blockposition, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(LevelAccessor world, BlockPos position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.AIR.defaultBlockState()).isCancelled()) {
            world.removeBlock(position, false);
        }
    }
}

