/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.entity.EntityTargetEvent;

public class BeehiveBlock
extends BaseEntityBlock {
    public static final MapCodec<BeehiveBlock> CODEC = BeehiveBlock.simpleCodec(BeehiveBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty HONEY_LEVEL = BlockStateProperties.LEVEL_HONEY;
    public static final int MAX_HONEY_LEVELS = 5;

    public MapCodec<BeehiveBlock> codec() {
        return CODEC;
    }

    public BeehiveBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HONEY_LEVEL, 0)).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(HONEY_LEVEL);
    }

    @Override
    public void playerDestroy(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata, @Nullable BlockEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, iblockdata, tileentity, itemstack);
        if (!world.isClientSide() && tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            if (!EnchantmentHelper.hasTag(itemstack, EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                tileentitybeehive.emptyAllLivingFromHive(entityhuman, iblockdata, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                Containers.updateNeighboursAfterDestroy(iblockdata, world, blockposition);
                this.angerNearbyBees(world, blockposition);
            }
            CriteriaTriggers.BEE_NEST_DESTROYED.trigger((ServerPlayer)entityhuman, iblockdata, itemstack, tileentitybeehive.getOccupantCount());
        }
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
        this.angerNearbyBees(worldserver, blockposition);
    }

    private void angerNearbyBees(Level world, BlockPos blockposition) {
        AABB axisalignedbb = new AABB(blockposition).inflate(8.0, 6.0, 8.0);
        List<Bee> list = world.getEntitiesOfClass(Bee.class, axisalignedbb);
        if (!list.isEmpty()) {
            List<Player> list1 = world.getEntitiesOfClass(Player.class, axisalignedbb);
            if (list1.isEmpty()) {
                return;
            }
            for (Bee entitybee : list) {
                if (entitybee.getTarget() != null) continue;
                Player entityhuman = Util.getRandom(list1, world.random);
                entitybee.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
            }
        }
    }

    public static void dropHoneycomb(ServerLevel worldserver, ItemStack itemstack, BlockState iblockdata, @Nullable BlockEntity tileentity, @Nullable Entity entity, BlockPos blockposition) {
        BeehiveBlock.dropFromBlockInteractLootTable(worldserver, BuiltInLootTables.HARVEST_BEEHIVE, iblockdata, tileentity, itemstack, entity, (worldserver1, itemstack1) -> BeehiveBlock.popResource((Level)worldserver1, blockposition, itemstack1));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        block11: {
            i = iblockdata.getValue(BeehiveBlock.HONEY_LEVEL);
            flag = false;
            if (i < 5) break block11;
            item = itemstack.getItem();
            if (!(world instanceof ServerLevel)) ** GOTO lbl-1000
            worldserver = (ServerLevel)world;
            if (itemstack.is(Items.SHEARS)) {
                BeehiveBlock.dropHoneycomb(worldserver, itemstack, iblockdata, world.getBlockEntity(blockposition), entityhuman, blockposition);
                world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                itemstack.hurtAndBreak(1, (LivingEntity)entityhuman, enumhand.asEquipmentSlot());
                flag = true;
                world.gameEvent((Entity)entityhuman, GameEvent.SHEAR, blockposition);
            } else if (itemstack.is(Items.GLASS_BOTTLE)) {
                itemstack.shrink(1);
                world.playSound((Entity)entityhuman, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (itemstack.isEmpty()) {
                    entityhuman.setItemInHand(enumhand, new ItemStack(Items.HONEY_BOTTLE));
                } else if (!entityhuman.getInventory().add(new ItemStack(Items.HONEY_BOTTLE))) {
                    entityhuman.drop(new ItemStack(Items.HONEY_BOTTLE), false);
                }
                flag = true;
                world.gameEvent((Entity)entityhuman, GameEvent.FLUID_PICKUP, blockposition);
            }
            if (!world.isClientSide() && flag) {
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
        }
        if (flag) {
            if (!CampfireBlock.isSmokeyPos(world, blockposition)) {
                if (this.hiveContainsBees(world, blockposition)) {
                    this.angerNearbyBees(world, blockposition);
                }
                this.releaseBeesAndResetHoneyLevel(world, iblockdata, blockposition, entityhuman, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            } else {
                this.resetHoneyLevel(world, iblockdata, blockposition);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    private boolean hiveContainsBees(Level world, BlockPos blockposition) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            return !tileentitybeehive.isEmpty();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(Level world, BlockState iblockdata, BlockPos blockposition, @Nullable Player entityhuman, BeehiveBlockEntity.BeeReleaseStatus tileentitybeehive_releasestatus) {
        this.resetHoneyLevel(world, iblockdata, blockposition);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(entityhuman, iblockdata, tileentitybeehive_releasestatus);
        }
    }

    public void resetHoneyLevel(Level world, BlockState iblockdata, BlockPos blockposition) {
        world.setBlock(blockposition, (BlockState)iblockdata.setValue(HONEY_LEVEL, 0), 3);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(HONEY_LEVEL) >= 5) {
            for (int i = 0; i < randomsource.nextInt(1) + 1; ++i) {
                this.trySpawnDripParticles(world, blockposition, iblockdata);
            }
        }
    }

    private void trySpawnDripParticles(Level world, BlockPos blockposition, BlockState iblockdata) {
        VoxelShape voxelshape;
        double d0;
        if (iblockdata.getFluidState().isEmpty() && world.random.nextFloat() >= 0.3f && (d0 = (voxelshape = iblockdata.getCollisionShape(world, blockposition)).max(Direction.Axis.Y)) >= 1.0 && !iblockdata.is(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.min(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(world, blockposition, voxelshape, (double)blockposition.getY() + d1 - 0.05);
            } else {
                BlockPos blockposition1 = blockposition.below();
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                VoxelShape voxelshape1 = iblockdata1.getCollisionShape(world, blockposition1);
                double d2 = voxelshape1.max(Direction.Axis.Y);
                if ((d2 < 1.0 || !iblockdata1.isCollisionShapeFullBlock(world, blockposition1)) && iblockdata1.getFluidState().isEmpty()) {
                    this.spawnParticle(world, blockposition, voxelshape, (double)blockposition.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level world, BlockPos blockposition, VoxelShape voxelshape, double d0) {
        this.spawnFluidParticle(world, (double)blockposition.getX() + voxelshape.min(Direction.Axis.X), (double)blockposition.getX() + voxelshape.max(Direction.Axis.X), (double)blockposition.getZ() + voxelshape.min(Direction.Axis.Z), (double)blockposition.getZ() + voxelshape.max(Direction.Axis.Z), d0);
    }

    private void spawnFluidParticle(Level world, double d0, double d1, double d2, double d3, double d4) {
        world.addParticle(ParticleTypes.DRIPPING_HONEY, Mth.lerp(world.random.nextDouble(), d0, d1), d4, Mth.lerp(world.random.nextDouble(), d2, d3), 0.0, 0.0, 0.0);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(HONEY_LEVEL, FACING);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new BeehiveBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return world.isClientSide() ? null : BeehiveBlock.createTickerHelper(tileentitytypes, BlockEntityType.BEEHIVE, BeehiveBlockEntity::serverTick);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (world instanceof ServerLevel) {
            BlockEntity tileentity;
            ServerLevel worldserver = (ServerLevel)world;
            if (entityhuman.preventsBlockDrops() && worldserver.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (tileentity = world.getBlockEntity(blockposition)) instanceof BeehiveBlockEntity) {
                boolean flag;
                BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
                int i = iblockdata.getValue(HONEY_LEVEL);
                boolean bl = flag = !tileentitybeehive.isEmpty();
                if (flag || i > 0) {
                    ItemStack itemstack = new ItemStack(this);
                    itemstack.applyComponents(tileentitybeehive.collectComponents());
                    itemstack.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(HONEY_LEVEL, i));
                    ItemEntity entityitem = new ItemEntity(world, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack);
                    entityitem.setDefaultPickUpDelay();
                    world.addFreshEntity(entityitem);
                }
            }
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState iblockdata, LootParams.Builder lootparams_a) {
        BlockEntity tileentity;
        Entity entity = lootparams_a.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (tileentity = lootparams_a.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(null, iblockdata, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.getDrops(iblockdata, lootparams_a);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        ItemStack itemstack = super.getCloneItemStack(iworldreader, blockposition, iblockdata, flag);
        if (flag) {
            itemstack.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(HONEY_LEVEL, iblockdata.getValue(HONEY_LEVEL)));
        }
        return itemstack;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        BlockEntity tileentity;
        if (iworldreader.getBlockState(blockposition1).getBlock() instanceof FireBlock && (tileentity = iworldreader.getBlockEntity(blockposition)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(null, iblockdata, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }
}

