/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BuddingAmethystBlock
extends AmethystBlock {
    public static final MapCodec<BuddingAmethystBlock> CODEC = BuddingAmethystBlock.simpleCodec(BuddingAmethystBlock::new);
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public MapCodec<BuddingAmethystBlock> codec() {
        return CODEC;
    }

    public BuddingAmethystBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (randomsource.nextInt(5) == 0) {
            Direction enumdirection = DIRECTIONS[randomsource.nextInt(DIRECTIONS.length)];
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            BlockState iblockdata1 = worldserver.getBlockState(blockposition1);
            Block block = null;
            if (BuddingAmethystBlock.canClusterGrowAtState(iblockdata1)) {
                block = Blocks.SMALL_AMETHYST_BUD;
            } else if (iblockdata1.is(Blocks.SMALL_AMETHYST_BUD) && iblockdata1.getValue(AmethystClusterBlock.FACING) == enumdirection) {
                block = Blocks.MEDIUM_AMETHYST_BUD;
            } else if (iblockdata1.is(Blocks.MEDIUM_AMETHYST_BUD) && iblockdata1.getValue(AmethystClusterBlock.FACING) == enumdirection) {
                block = Blocks.LARGE_AMETHYST_BUD;
            } else if (iblockdata1.is(Blocks.LARGE_AMETHYST_BUD) && iblockdata1.getValue(AmethystClusterBlock.FACING) == enumdirection) {
                block = Blocks.AMETHYST_CLUSTER;
            }
            if (block != null) {
                BlockState iblockdata2 = (BlockState)((BlockState)block.defaultBlockState().setValue(AmethystClusterBlock.FACING, enumdirection)).setValue(AmethystClusterBlock.WATERLOGGED, iblockdata1.getFluidState().getType() == Fluids.WATER);
                CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, iblockdata2);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState iblockdata) {
        return iblockdata.isAir() || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().getAmount() == 8;
    }
}

