/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class CauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<CauldronBlock> CODEC = CauldronBlock.simpleCodec(CauldronBlock::new);
    private static final float RAIN_FILL_CHANCE = 0.05f;
    private static final float POWDER_SNOW_FILL_CHANCE = 0.1f;

    public MapCodec<CauldronBlock> codec() {
        return CODEC;
    }

    public CauldronBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info, CauldronInteraction.EMPTY);
    }

    @Override
    public boolean isFull(BlockState iblockdata) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(Level world, Biome.Precipitation biomebase_precipitation) {
        return biomebase_precipitation == Biome.Precipitation.RAIN ? world.getRandom().nextFloat() < 0.05f : (biomebase_precipitation == Biome.Precipitation.SNOW ? world.getRandom().nextFloat() < 0.1f : false);
    }

    @Override
    public void handlePrecipitation(BlockState iblockdata, Level world, BlockPos blockposition, Biome.Precipitation biomebase_precipitation) {
        if (CauldronBlock.shouldHandlePrecipitation(world, biomebase_precipitation)) {
            if (biomebase_precipitation == Biome.Precipitation.RAIN) {
                world.setBlockAndUpdate(blockposition, Blocks.WATER_CAULDRON.defaultBlockState());
                world.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
            } else if (biomebase_precipitation == Biome.Precipitation.SNOW) {
                world.setBlockAndUpdate(blockposition, Blocks.POWDER_SNOW_CAULDRON.defaultBlockState());
                world.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
            }
        }
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid fluidtype) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(BlockState iblockdata, Level world, BlockPos blockposition, Fluid fluidtype) {
        if (fluidtype == Fluids.WATER) {
            BlockState iblockdata1 = Blocks.WATER_CAULDRON.defaultBlockState();
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
            world.levelEvent(1047, blockposition, 0);
        } else if (fluidtype == Fluids.LAVA) {
            BlockState iblockdata2 = Blocks.LAVA_CAULDRON.defaultBlockState();
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata2, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
            world.levelEvent(1046, blockposition, 0);
        }
    }
}

