/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class ChorusFlowerBlock
extends Block {
    public static final MapCodec<ChorusFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plant").forGetter(blockchorusflower -> blockchorusflower.plant), ChorusFlowerBlock.propertiesCodec()).apply((Applicative)instance, ChorusFlowerBlock::new));
    public static final int DEAD_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    private static final VoxelShape SHAPE_BLOCK_SUPPORT = Block.column(14.0, 0.0, 15.0);
    private final Block plant;

    public MapCodec<ChorusFlowerBlock> codec() {
        return CODEC;
    }

    protected ChorusFlowerBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.plant = block;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 5;
    }

    @Override
    public VoxelShape getBlockSupportShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return SHAPE_BLOCK_SUPPORT;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        int i;
        BlockPos blockposition1 = blockposition.above();
        if (worldserver.isEmptyBlock(blockposition1) && blockposition1.getY() <= worldserver.getMaxY() && (i = iblockdata.getValue(AGE).intValue()) < 5) {
            boolean flag = false;
            boolean flag1 = false;
            BlockState iblockdata1 = worldserver.getBlockState(blockposition.below());
            if (iblockdata1.is(Blocks.END_STONE)) {
                flag = true;
            } else if (iblockdata1.is(this.plant)) {
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    BlockState iblockdata2 = worldserver.getBlockState(blockposition.below(j + 1));
                    if (!iblockdata2.is(this.plant)) {
                        if (!iblockdata2.is(Blocks.END_STONE)) break;
                        flag1 = true;
                        break;
                    }
                    ++j;
                }
                if (j < 2 || j <= randomsource.nextInt(flag1 ? 5 : 4)) {
                    flag = true;
                }
            } else if (iblockdata1.isAir()) {
                flag = true;
            }
            if (flag && ChorusFlowerBlock.allNeighborsEmpty(worldserver, blockposition1, null) && worldserver.isEmptyBlock(blockposition.above(2))) {
                if (CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, (BlockState)this.defaultBlockState().setValue(AGE, i), 2)) {
                    worldserver.setBlock(blockposition, ChorusPlantBlock.getStateWithConnections(worldserver, blockposition, this.plant.defaultBlockState()), 2);
                    this.placeGrownFlower(worldserver, blockposition1, i);
                }
            } else if (i < 4) {
                int l = randomsource.nextInt(4);
                if (flag1) {
                    ++l;
                }
                boolean flag2 = false;
                for (int i1 = 0; i1 < l; ++i1) {
                    Direction enumdirection = Direction.Plane.HORIZONTAL.getRandomDirection(randomsource);
                    BlockPos blockposition2 = blockposition.relative(enumdirection);
                    if (!worldserver.isEmptyBlock(blockposition2) || !worldserver.isEmptyBlock(blockposition2.below()) || !ChorusFlowerBlock.allNeighborsEmpty(worldserver, blockposition2, enumdirection.getOpposite()) || !CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition2, (BlockState)this.defaultBlockState().setValue(AGE, i + 1), 2)) continue;
                    this.placeGrownFlower(worldserver, blockposition2, i + 1);
                    flag2 = true;
                }
                if (flag2) {
                    worldserver.setBlock(blockposition, ChorusPlantBlock.getStateWithConnections(worldserver, blockposition, this.plant.defaultBlockState()), 2);
                } else if (CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2)) {
                    this.placeDeadFlower(worldserver, blockposition);
                }
            } else if (CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2)) {
                this.placeDeadFlower(worldserver, blockposition);
            }
        }
    }

    private void placeGrownFlower(Level world, BlockPos blockposition, int i) {
        world.setBlock(blockposition, (BlockState)this.defaultBlockState().setValue(AGE, i), 2);
        world.levelEvent(1033, blockposition, 0);
    }

    private void placeDeadFlower(Level world, BlockPos blockposition) {
        world.setBlock(blockposition, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2);
        world.levelEvent(1034, blockposition, 0);
    }

    private static boolean allNeighborsEmpty(LevelReader iworldreader, BlockPos blockposition, @Nullable Direction enumdirection) {
        for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
            if (enumdirection1 == enumdirection || iworldreader.isEmptyBlock(blockposition.relative(enumdirection1))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection != Direction.UP && !iblockdata.canSurvive(iworldreader, blockposition)) {
            scheduledtickaccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.below());
        if (!iblockdata1.is(this.plant) && !iblockdata1.is(Blocks.END_STONE)) {
            if (!iblockdata1.isAir()) {
                return false;
            }
            boolean flag = false;
            for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                BlockState iblockdata2 = iworldreader.getBlockState(blockposition.relative(enumdirection));
                if (iblockdata2.is(this.plant)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (iblockdata2.isAir()) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    public static void generatePlant(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, int i) {
        generatoraccess.setBlock(blockposition, ChorusPlantBlock.getStateWithConnections(generatoraccess, blockposition, Blocks.CHORUS_PLANT.defaultBlockState()), 2);
        ChorusFlowerBlock.growTreeRecursive(generatoraccess, blockposition, randomsource, blockposition, i, 0);
    }

    private static void growTreeRecursive(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, BlockPos blockposition1, int i, int j) {
        Block block = Blocks.CHORUS_PLANT;
        int k = randomsource.nextInt(4) + 1;
        if (j == 0) {
            ++k;
        }
        for (int l = 0; l < k; ++l) {
            BlockPos blockposition2 = blockposition.above(l + 1);
            if (!ChorusFlowerBlock.allNeighborsEmpty(generatoraccess, blockposition2, null)) {
                return;
            }
            generatoraccess.setBlock(blockposition2, ChorusPlantBlock.getStateWithConnections(generatoraccess, blockposition2, block.defaultBlockState()), 2);
            generatoraccess.setBlock(blockposition2.below(), ChorusPlantBlock.getStateWithConnections(generatoraccess, blockposition2.below(), block.defaultBlockState()), 2);
        }
        boolean flag = false;
        if (j < 4) {
            int i1 = randomsource.nextInt(4);
            if (j == 0) {
                ++i1;
            }
            for (int j1 = 0; j1 < i1; ++j1) {
                Direction enumdirection = Direction.Plane.HORIZONTAL.getRandomDirection(randomsource);
                BlockPos blockposition3 = blockposition.above(k).relative(enumdirection);
                if (Math.abs(blockposition3.getX() - blockposition1.getX()) >= i || Math.abs(blockposition3.getZ() - blockposition1.getZ()) >= i || !generatoraccess.isEmptyBlock(blockposition3) || !generatoraccess.isEmptyBlock(blockposition3.below()) || !ChorusFlowerBlock.allNeighborsEmpty(generatoraccess, blockposition3, enumdirection.getOpposite())) continue;
                flag = true;
                generatoraccess.setBlock(blockposition3, ChorusPlantBlock.getStateWithConnections(generatoraccess, blockposition3, block.defaultBlockState()), 2);
                generatoraccess.setBlock(blockposition3.relative(enumdirection.getOpposite()), ChorusPlantBlock.getStateWithConnections(generatoraccess, blockposition3.relative(enumdirection.getOpposite()), block.defaultBlockState()), 2);
                ChorusFlowerBlock.growTreeRecursive(generatoraccess, blockposition3, randomsource, blockposition1, i, j + 1);
            }
        }
        if (!flag) {
            generatoraccess.setBlock(blockposition.above(k), (BlockState)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        ServerLevel worldserver;
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        if (world instanceof ServerLevel && iprojectile.mayInteract(worldserver = (ServerLevel)world, blockposition) && iprojectile.mayBreak(worldserver)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState())) {
                return;
            }
            world.destroyBlock(blockposition, true, iprojectile);
        }
    }
}

