/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.redstone.Orientation;

public class FrostedIceBlock
extends IceBlock {
    public static final MapCodec<FrostedIceBlock> CODEC = FrostedIceBlock.simpleCodec(FrostedIceBlock::new);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final int NEIGHBORS_TO_AGE = 4;
    private static final int NEIGHBORS_TO_MELT = 2;

    public MapCodec<FrostedIceBlock> codec() {
        return CODEC;
    }

    public FrostedIceBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        var1.scheduleTick(var2, this, Mth.nextInt(var1.getRandom(), 60, 120));
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (var3.nextInt(3) == 0 || this.fewerNeigboursThan(var1, var2, 4)) {
            int var4;
            int n = var4 = var1.dimension() == Level.END ? var1.getBrightness(LightLayer.BLOCK, var2) : var1.getMaxLocalRawBrightness(var2);
            if (var4 > 11 - var0.getValue(AGE) - var0.getLightBlock() && this.slightlyMelt(var0, var1, var2)) {
                BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
                for (Direction var9 : Direction.values()) {
                    var5.setWithOffset((Vec3i)var2, var9);
                    BlockState var10 = var1.getBlockState(var5);
                    if (!var10.is(this) || this.slightlyMelt(var10, var1, var5)) continue;
                    var1.scheduleTick((BlockPos)var5, this, Mth.nextInt(var3, 20, 40));
                }
                return;
            }
        }
        var1.scheduleTick(var2, this, Mth.nextInt(var3, 20, 40));
    }

    private boolean slightlyMelt(BlockState var0, Level var1, BlockPos var2) {
        int var3 = var0.getValue(AGE);
        if (var3 < 3) {
            var1.setBlock(var2, (BlockState)var0.setValue(AGE, var3 + 1), 2);
            return false;
        }
        this.melt(var0, var1, var2);
        return true;
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var3.defaultBlockState().is(this) && this.fewerNeigboursThan(var1, var2, 2)) {
            this.melt(var0, var1, var2);
        }
        super.neighborChanged(var0, var1, var2, var3, var4, var5);
    }

    private boolean fewerNeigboursThan(BlockGetter var0, BlockPos var1, int var2) {
        int var3 = 0;
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (Direction var8 : Direction.values()) {
            var4.setWithOffset((Vec3i)var1, var8);
            if (!var0.getBlockState(var4).is(this) || ++var3 < var2) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(AGE);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        return ItemStack.EMPTY;
    }
}

