/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.TreeType;

public class FungusBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<FungusBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(Registries.CONFIGURED_FEATURE).fieldOf("feature").forGetter(blockfungi -> blockfungi.feature), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("grows_on").forGetter(blockfungi -> blockfungi.requiredBlock), FungusBlock.propertiesCodec()).apply((Applicative)instance, FungusBlock::new));
    private static final double BONEMEAL_SUCCESS_PROBABILITY = 0.4;
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 9.0);
    private final Block requiredBlock;
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;

    public MapCodec<FungusBlock> codec() {
        return CODEC;
    }

    protected FungusBlock(ResourceKey<ConfiguredFeature<?, ?>> resourcekey, Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.feature = resourcekey;
        this.requiredBlock = block;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockdata.is(BlockTags.NYLIUM) || iblockdata.is(Blocks.MYCELIUM) || iblockdata.is(Blocks.SOUL_SOIL) || super.mayPlaceOn(iblockdata, iblockaccess, blockposition);
    }

    private Optional<? extends Holder<ConfiguredFeature<?, ?>>> getFeature(LevelReader iworldreader) {
        return iworldreader.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.feature);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.below());
        return iblockdata1.is(this.requiredBlock);
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return (double)randomsource.nextFloat() < 0.4;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        this.getFeature(worldserver).ifPresent(holder -> {
            if (this == Blocks.WARPED_FUNGUS) {
                SaplingBlock.treeType = TreeType.WARPED_FUNGUS;
            } else if (this == Blocks.CRIMSON_FUNGUS) {
                SaplingBlock.treeType = TreeType.CRIMSON_FUNGUS;
            }
            ((ConfiguredFeature)holder.value()).place(worldserver, worldserver.getChunkSource().getGenerator(), randomsource, blockposition);
        });
    }
}

