/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoneyBlock
extends HalfTransparentBlock {
    public static final MapCodec<HoneyBlock> CODEC = HoneyBlock.simpleCodec(HoneyBlock::new);
    private static final double SLIDE_STARTS_WHEN_VERTICAL_SPEED_IS_AT_LEAST = 0.13;
    private static final double MIN_FALL_SPEED_TO_BE_CONSIDERED_SLIDING = 0.08;
    private static final double THROTTLE_SLIDE_SPEED_TO = 0.05;
    private static final int SLIDE_ADVANCEMENT_CHECK_INTERVAL = 20;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 15.0);

    public MapCodec<HoneyBlock> codec() {
        return CODEC;
    }

    public HoneyBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity var0) {
        return var0 instanceof LivingEntity || var0 instanceof AbstractMinecart || var0 instanceof PrimedTnt || var0 instanceof AbstractBoat;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    public void fallOn(Level var0, BlockState var1, BlockPos var2, Entity var3, double var4) {
        var3.playSound(SoundEvents.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
        if (!var0.isClientSide()) {
            var0.broadcastEntityEvent(var3, (byte)54);
        }
        if (var3.causeFallDamage(var4, 0.2f, var0.damageSources().fall())) {
            var3.playSound(this.soundType.getFallSound(), this.soundType.getVolume() * 0.5f, this.soundType.getPitch() * 0.75f);
        }
    }

    @Override
    protected void entityInside(BlockState var0, Level var1, BlockPos var2, Entity var3, InsideBlockEffectApplier var4) {
        if (this.isSlidingDown(var2, var3)) {
            this.maybeDoSlideAchievement(var3, var2);
            this.doSlideMovement(var3);
            this.maybeDoSlideEffects(var1, var3);
        }
        super.entityInside(var0, var1, var2, var3, var4);
    }

    private static double getOldDeltaY(double var0) {
        return var0 / (double)0.98f + 0.08;
    }

    private static double getNewDeltaY(double var0) {
        return (var0 - 0.08) * (double)0.98f;
    }

    private boolean isSlidingDown(BlockPos var0, Entity var1) {
        if (var1.onGround()) {
            return false;
        }
        if (var1.getY() > (double)var0.getY() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (HoneyBlock.getOldDeltaY(var1.getDeltaMovement().y) >= -0.08) {
            return false;
        }
        double var2 = Math.abs((double)var0.getX() + 0.5 - var1.getX());
        double var4 = Math.abs((double)var0.getZ() + 0.5 - var1.getZ());
        double var6 = 0.4375 + (double)(var1.getBbWidth() / 2.0f);
        return var2 + 1.0E-7 > var6 || var4 + 1.0E-7 > var6;
    }

    private void maybeDoSlideAchievement(Entity var0, BlockPos var1) {
        if (var0 instanceof ServerPlayer && var0.level().getGameTime() % 20L == 0L) {
            CriteriaTriggers.HONEY_BLOCK_SLIDE.trigger((ServerPlayer)var0, var0.level().getBlockState(var1));
        }
    }

    private void doSlideMovement(Entity var0) {
        Vec3 var1 = var0.getDeltaMovement();
        if (HoneyBlock.getOldDeltaY(var0.getDeltaMovement().y) < -0.13) {
            double var2 = -0.05 / HoneyBlock.getOldDeltaY(var0.getDeltaMovement().y);
            var0.setDeltaMovement(new Vec3(var1.x * var2, HoneyBlock.getNewDeltaY(-0.05), var1.z * var2));
        } else {
            var0.setDeltaMovement(new Vec3(var1.x, HoneyBlock.getNewDeltaY(-0.05), var1.z));
        }
        var0.resetFallDistance();
    }

    private void maybeDoSlideEffects(Level var0, Entity var1) {
        if (HoneyBlock.doesEntityDoHoneyBlockSlideEffects(var1)) {
            if (var0.random.nextInt(5) == 0) {
                var1.playSound(SoundEvents.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
            }
            if (!var0.isClientSide() && var0.random.nextInt(5) == 0) {
                var0.broadcastEntityEvent(var1, (byte)53);
            }
        }
    }

    public static void showSlideParticles(Entity var0) {
        HoneyBlock.showParticles(var0, 5);
    }

    public static void showJumpParticles(Entity var0) {
        HoneyBlock.showParticles(var0, 10);
    }

    private static void showParticles(Entity var0, int var1) {
        if (!var0.level().isClientSide()) {
            return;
        }
        BlockState var2 = Blocks.HONEY_BLOCK.defaultBlockState();
        for (int var3 = 0; var3 < var1; ++var3) {
            var0.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, var2), var0.getX(), var0.getY(), var0.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

