/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.BlockHitResult;

public class JukeboxBlock
extends BaseEntityBlock {
    public static final MapCodec<JukeboxBlock> CODEC = JukeboxBlock.simpleCodec(JukeboxBlock::new);
    public static final BooleanProperty HAS_RECORD = BlockStateProperties.HAS_RECORD;

    public MapCodec<JukeboxBlock> codec() {
        return CODEC;
    }

    protected JukeboxBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HAS_RECORD, false));
    }

    @Override
    public void setPlacedBy(Level var0, BlockPos var1, BlockState var2, @Nullable LivingEntity var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        TypedEntityData<BlockEntityType<?>> var5 = var4.get(DataComponents.BLOCK_ENTITY_DATA);
        if (var5 != null && var5.contains("RecordItem")) {
            var0.setBlock(var1, (BlockState)var2.setValue(HAS_RECORD, true), 2);
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity blockEntity;
        if (var0.getValue(HAS_RECORD).booleanValue() && (blockEntity = var1.getBlockEntity(var2)) instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity var5 = (JukeboxBlockEntity)blockEntity;
            var5.popOutTheItem();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        if (var1.getValue(HAS_RECORD).booleanValue()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ItemStack var7 = var4.getItemInHand(var5);
        InteractionResult var8 = JukeboxPlayable.tryInsertIntoJukebox(var2, var3, var7, var4);
        if (!var8.consumesAction()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return var8;
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new JukeboxBlockEntity(var0, var1);
    }

    @Override
    public boolean isSignalSource(BlockState var0) {
        return true;
    }

    @Override
    public int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        JukeboxBlockEntity var4;
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof JukeboxBlockEntity && (var4 = (JukeboxBlockEntity)blockEntity).getSongPlayer().isPlaying()) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity var4 = (JukeboxBlockEntity)blockEntity;
            return var4.getComparatorOutput();
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(HAS_RECORD);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        if (var1.getValue(HAS_RECORD).booleanValue()) {
            return JukeboxBlock.createTickerHelper(var2, BlockEntityType.JUKEBOX, JukeboxBlockEntity::tick);
        }
        return null;
    }
}

