/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MangrovePropaguleBlock
extends SaplingBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<MangrovePropaguleBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)TreeGrower.CODEC.fieldOf("tree").forGetter(var0 -> var0.treeGrower), MangrovePropaguleBlock.propertiesCodec()).apply((Applicative)var02, MangrovePropaguleBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int MAX_AGE = 4;
    private static final int[] SHAPE_MIN_Y = new int[]{13, 10, 7, 3, 0};
    private static final VoxelShape[] SHAPE_PER_AGE = Block.boxes(4, var0 -> Block.column(2.0, SHAPE_MIN_Y[var0], 16.0));
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;

    public MapCodec<MangrovePropaguleBlock> codec() {
        return CODEC;
    }

    public MangrovePropaguleBlock(TreeGrower var0, BlockBehaviour.Properties var1) {
        super(var0, var1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(STAGE, 0)).setValue(AGE, 0)).setValue(WATERLOGGED, false)).setValue(HANGING, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(STAGE).add(AGE).add(WATERLOGGED).add(HANGING);
    }

    @Override
    protected boolean mayPlaceOn(BlockState var0, BlockGetter var1, BlockPos var2) {
        return super.mayPlaceOn(var0, var1, var2) || var0.is(Blocks.CLAY);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        FluidState var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(var0).setValue(WATERLOGGED, var2)).setValue(AGE, 4);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        int var4 = var0.getValue(HANGING) != false ? var0.getValue(AGE) : 4;
        return SHAPE_PER_AGE[var4].move(var0.getOffset(var2));
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        if (MangrovePropaguleBlock.isHanging(var0)) {
            return var1.getBlockState(var2.above()).is(Blocks.MANGROVE_LEAVES);
        }
        return super.canSurvive(var0, var1, var2);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        if (var4 == Direction.UP && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void randomTick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!MangrovePropaguleBlock.isHanging(var0)) {
            if (var3.nextInt(7) == 0) {
                this.advanceTree(var1, var2, var0, var3);
            }
            return;
        }
        if (!MangrovePropaguleBlock.isFullyGrown(var0)) {
            var1.setBlock(var2, (BlockState)var0.cycle(AGE), 2);
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return !MangrovePropaguleBlock.isHanging(var2) || !MangrovePropaguleBlock.isFullyGrown(var2);
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return MangrovePropaguleBlock.isHanging(var3) ? !MangrovePropaguleBlock.isFullyGrown(var3) : super.isBonemealSuccess(var0, var1, var2, var3);
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        if (MangrovePropaguleBlock.isHanging(var3) && !MangrovePropaguleBlock.isFullyGrown(var3)) {
            var0.setBlock(var2, (BlockState)var3.cycle(AGE), 2);
        } else {
            super.performBonemeal(var0, var1, var2, var3);
        }
    }

    private static boolean isHanging(BlockState var0) {
        return var0.getValue(HANGING);
    }

    private static boolean isFullyGrown(BlockState var0) {
        return var0.getValue(AGE) == 4;
    }

    public static BlockState createNewHangingPropagule() {
        return MangrovePropaguleBlock.createNewHangingPropagule(0);
    }

    public static BlockState createNewHangingPropagule(int var0) {
        return (BlockState)((BlockState)Blocks.MANGROVE_PROPAGULE.defaultBlockState().setValue(HANGING, true)).setValue(AGE, var0);
    }
}

