/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class TorchBlock
extends BaseTorchBlock {
    protected static final MapCodec<SimpleParticleType> PARTICLE_OPTIONS_FIELD = BuiltInRegistries.PARTICLE_TYPE.byNameCodec().comapFlatMap(var0 -> {
        DataResult dataResult;
        if (var0 instanceof SimpleParticleType) {
            SimpleParticleType var1 = (SimpleParticleType)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error(() -> "Not a SimpleParticleType: " + String.valueOf(var0));
        }
        return dataResult;
    }, var0 -> var0).fieldOf("particle_options");
    public static final MapCodec<TorchBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)PARTICLE_OPTIONS_FIELD.forGetter(var0 -> var0.flameParticle), TorchBlock.propertiesCodec()).apply((Applicative)var02, TorchBlock::new));
    protected final SimpleParticleType flameParticle;

    public MapCodec<? extends TorchBlock> codec() {
        return CODEC;
    }

    protected TorchBlock(SimpleParticleType var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.flameParticle = var0;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        double var4 = (double)var2.getX() + 0.5;
        double var6 = (double)var2.getY() + 0.7;
        double var8 = (double)var2.getZ() + 0.5;
        var1.addParticle(ParticleTypes.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
        var1.addParticle(this.flameParticle, var4, var6, var8, 0.0, 0.0, 0.0);
    }
}

