/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class SculkShriekerBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private static final int WARNING_SOUND_RADIUS = 10;
    private static final int WARDEN_SPAWN_ATTEMPTS = 20;
    private static final int WARDEN_SPAWN_RANGE_XZ = 5;
    private static final int WARDEN_SPAWN_RANGE_Y = 6;
    private static final int DARKNESS_RADIUS = 40;
    private static final int SHRIEKING_TICKS = 90;
    private static final Int2ObjectMap<SoundEvent> SOUND_BY_LEVEL = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(), var0 -> {
        var0.put(1, (Object)SoundEvents.WARDEN_NEARBY_CLOSE);
        var0.put(2, (Object)SoundEvents.WARDEN_NEARBY_CLOSER);
        var0.put(3, (Object)SoundEvents.WARDEN_NEARBY_CLOSEST);
        var0.put(4, (Object)SoundEvents.WARDEN_LISTENING_ANGRY);
    });
    private static final int DEFAULT_WARNING_LEVEL = 0;
    public int warningLevel = 0;
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener(this);

    public SculkShriekerBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.SCULK_SHRIEKER, var0, var1);
    }

    @Override
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.warningLevel = var0.getIntOr("warning_level", 0);
        this.vibrationData = var0.read("listener", VibrationSystem.Data.CODEC).orElseGet(VibrationSystem.Data::new);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.putInt("warning_level", this.warningLevel);
        var0.store("listener", VibrationSystem.Data.CODEC, this.vibrationData);
    }

    @Nullable
    public static ServerPlayer tryGetPlayer(@Nullable Entity var0) {
        ServerPlayer var2;
        Entity var1;
        Entity entity;
        LivingEntity livingEntity;
        if (var0 instanceof ServerPlayer) {
            ServerPlayer var12 = (ServerPlayer)var0;
            return var12;
        }
        if (var0 != null && (livingEntity = var0.getControllingPassenger()) instanceof ServerPlayer) {
            ServerPlayer var13 = (ServerPlayer)livingEntity;
            return var13;
        }
        if (var0 instanceof Projectile && (entity = ((Projectile)(var1 = (Projectile)var0)).getOwner()) instanceof ServerPlayer) {
            var2 = (ServerPlayer)entity;
            return var2;
        }
        if (var0 instanceof ItemEntity && (entity = ((ItemEntity)(var1 = (ItemEntity)var0)).getOwner()) instanceof ServerPlayer) {
            var2 = (ServerPlayer)entity;
            return var2;
        }
        return null;
    }

    public void tryShriek(ServerLevel var0, @Nullable ServerPlayer var1) {
        if (var1 == null) {
            return;
        }
        BlockState var2 = this.getBlockState();
        if (var2.getValue(SculkShriekerBlock.SHRIEKING).booleanValue()) {
            return;
        }
        this.warningLevel = 0;
        if (this.canRespond(var0) && !this.tryToWarn(var0, var1)) {
            return;
        }
        this.shriek(var0, var1);
    }

    private boolean tryToWarn(ServerLevel var02, ServerPlayer var1) {
        OptionalInt var2 = WardenSpawnTracker.tryWarn(var02, this.getBlockPos(), var1);
        var2.ifPresent(var0 -> {
            this.warningLevel = var0;
        });
        return var2.isPresent();
    }

    private void shriek(ServerLevel var0, @Nullable Entity var1) {
        BlockPos var2 = this.getBlockPos();
        BlockState var3 = this.getBlockState();
        var0.setBlock(var2, (BlockState)var3.setValue(SculkShriekerBlock.SHRIEKING, true), 2);
        var0.scheduleTick(var2, var3.getBlock(), 90);
        var0.levelEvent(3007, var2, 0);
        var0.gameEvent(GameEvent.SHRIEK, var2, GameEvent.Context.of(var1));
    }

    private boolean canRespond(ServerLevel var0) {
        return this.getBlockState().getValue(SculkShriekerBlock.CAN_SUMMON) != false && var0.getDifficulty() != Difficulty.PEACEFUL && var0.getGameRules().getBoolean(GameRules.RULE_DO_WARDEN_SPAWNING);
    }

    @Override
    public void preRemoveSideEffects(BlockPos var0, BlockState var1) {
        Level level;
        if (var1.getValue(SculkShriekerBlock.SHRIEKING).booleanValue() && (level = this.level) instanceof ServerLevel) {
            ServerLevel var2 = (ServerLevel)level;
            this.tryRespond(var2);
        }
    }

    public void tryRespond(ServerLevel var0) {
        if (this.canRespond(var0) && this.warningLevel > 0) {
            if (!this.trySummonWarden(var0)) {
                this.playWardenReplySound(var0);
            }
            Warden.applyDarknessAround(var0, Vec3.atCenterOf(this.getBlockPos()), null, 40);
        }
    }

    private void playWardenReplySound(Level var0) {
        SoundEvent var1 = (SoundEvent)SOUND_BY_LEVEL.get(this.warningLevel);
        if (var1 != null) {
            BlockPos var2 = this.getBlockPos();
            int var3 = var2.getX() + Mth.randomBetweenInclusive(var0.random, -10, 10);
            int var4 = var2.getY() + Mth.randomBetweenInclusive(var0.random, -10, 10);
            int var5 = var2.getZ() + Mth.randomBetweenInclusive(var0.random, -10, 10);
            var0.playSound(null, (double)var3, (double)var4, (double)var5, var1, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(ServerLevel var0) {
        if (this.warningLevel < 4) {
            return false;
        }
        return SpawnUtil.trySpawnMob(EntityType.WARDEN, EntitySpawnReason.TRIGGERED, var0, this.getBlockPos(), 20, 5, 6, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER, false).isPresent();
    }

    @Override
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int LISTENER_RADIUS = 8;
        private final PositionSource positionSource;

        public VibrationUser() {
            this.positionSource = new BlockPositionSource(SculkShriekerBlockEntity.this.worldPosition);
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.SHRIEKER_CAN_LISTEN;
        }

        @Override
        public boolean canReceiveVibration(ServerLevel var0, BlockPos var1, Holder<GameEvent> var2, GameEvent.Context var3) {
            return SculkShriekerBlockEntity.this.getBlockState().getValue(SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(var3.sourceEntity()) != null;
        }

        @Override
        public void onReceiveVibration(ServerLevel var0, BlockPos var1, Holder<GameEvent> var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            SculkShriekerBlockEntity.this.tryShriek(var0, SculkShriekerBlockEntity.tryGetPlayer(var4 != null ? var4 : var3));
        }

        @Override
        public void onDataChanged() {
            SculkShriekerBlockEntity.this.setChanged();
        }

        @Override
        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

