/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class StateHolder<O, S> {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    public static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> var0) {
            if (var0 == null) {
                return "<NULL>";
            }
            Property<?> var1 = var0.getKey();
            return var1.getName() + "=" + this.getName(var1, var0.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> var0, Comparable<?> var1) {
            return var0.getName(var1);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O owner;
    private final Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    private Map<Property<?>, S[]> neighbours;
    protected final MapCodec<S> propertiesCodec;

    protected StateHolder(O var0, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var1, MapCodec<S> var2) {
        this.owner = var0;
        this.values = var1;
        this.propertiesCodec = var2;
    }

    public <T extends Comparable<T>> S cycle(Property<T> var0) {
        return this.setValue(var0, (Comparable)StateHolder.findNextInCollection(var0.getPossibleValues(), this.getValue(var0)));
    }

    protected static <T> T findNextInCollection(List<T> var0, T var1) {
        int var2 = var0.indexOf(var1) + 1;
        return var2 == var0.size() ? var0.getFirst() : var0.get(var2);
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        var0.append(this.owner);
        if (!this.getValues().isEmpty()) {
            var0.append('[');
            var0.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            var0.append(']');
        }
        return var0.toString();
    }

    public final boolean equals(Object var0) {
        return super.equals(var0);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    public boolean hasProperty(Property<?> var0) {
        return this.values.containsKey(var0);
    }

    public <T extends Comparable<T>> T getValue(Property<T> var0) {
        Comparable var1 = (Comparable)this.values.get(var0);
        if (var1 == null) {
            throw new IllegalArgumentException("Cannot get property " + String.valueOf(var0) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return (T)((Comparable)var0.getValueClass().cast(var1));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> var0) {
        return Optional.ofNullable(this.getNullableValue(var0));
    }

    public <T extends Comparable<T>> T getValueOrElse(Property<T> var0, T var1) {
        return (T)((Comparable)Objects.requireNonNullElse(this.getNullableValue(var0), var1));
    }

    @Nullable
    private <T extends Comparable<T>> T getNullableValue(Property<T> var0) {
        Comparable var1 = (Comparable)this.values.get(var0);
        if (var1 == null) {
            return null;
        }
        return (T)((Comparable)var0.getValueClass().cast(var1));
    }

    public <T extends Comparable<T>, V extends T> S setValue(Property<T> var0, V var1) {
        Comparable var2 = (Comparable)this.values.get(var0);
        if (var2 == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(var0) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return this.setValueInternal(var0, var1, var2);
    }

    public <T extends Comparable<T>, V extends T> S trySetValue(Property<T> var0, V var1) {
        Comparable var2 = (Comparable)this.values.get(var0);
        if (var2 == null) {
            return (S)this;
        }
        return this.setValueInternal(var0, var1, var2);
    }

    private <T extends Comparable<T>, V extends T> S setValueInternal(Property<T> var0, V var1, Comparable<?> var2) {
        if (var2.equals(var1)) {
            return (S)this;
        }
        int var3 = var0.getInternalIndex(var1);
        if (var3 < 0) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(var0) + " to " + String.valueOf(var1) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return this.neighbours.get(var0)[var3];
    }

    public void populateNeighbours(Map<Map<Property<?>, Comparable<?>>, S> var0) {
        if (this.neighbours != null) {
            throw new IllegalStateException();
        }
        Reference2ObjectArrayMap var1 = new Reference2ObjectArrayMap(this.values.size());
        for (Map.Entry var3 : this.values.entrySet()) {
            Property var4 = (Property)var3.getKey();
            var1.put(var4, var4.getPossibleValues().stream().map(var2 -> var0.get(this.makeNeighbourValues(var4, (Comparable<?>)var2))).toArray());
        }
        this.neighbours = var1;
    }

    private Map<Property<?>, Comparable<?>> makeNeighbourValues(Property<?> var0, Comparable<?> var1) {
        Reference2ObjectArrayMap var2 = new Reference2ObjectArrayMap(this.values);
        var2.put(var0, var1);
        return var2;
    }

    public Map<Property<?>, Comparable<?>> getValues() {
        return this.values;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> var02, Function<O, S> var1) {
        return var02.dispatch(NAME_TAG, var0 -> var0.owner, var12 -> {
            StateHolder var2 = (StateHolder)var1.apply(var12);
            if (var2.getValues().isEmpty()) {
                return MapCodec.unit((Object)var2);
            }
            return var2.propertiesCodec.codec().lenientOptionalFieldOf(PROPERTIES_TAG).xmap(var1 -> var1.orElse(var2), Optional::of);
        });
    }
}

