/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.BitSet;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class CarvingMask {
    private final int minY;
    private final BitSet mask;
    private Mask additionalMask = (var0, var1, var2) -> false;

    public CarvingMask(int var02, int var12) {
        this.minY = var12;
        this.mask = new BitSet(256 * var02);
    }

    public void setAdditionalMask(Mask var0) {
        this.additionalMask = var0;
    }

    public CarvingMask(long[] var02, int var12) {
        this.minY = var12;
        this.mask = BitSet.valueOf(var02);
    }

    private int getIndex(int var0, int var1, int var2) {
        return var0 & 0xF | (var2 & 0xF) << 4 | var1 - this.minY << 8;
    }

    public void set(int var0, int var1, int var2) {
        this.mask.set(this.getIndex(var0, var1, var2));
    }

    public boolean get(int var0, int var1, int var2) {
        return this.additionalMask.test(var0, var1, var2) || this.mask.get(this.getIndex(var0, var1, var2));
    }

    public Stream<BlockPos> stream(ChunkPos var0) {
        return this.mask.stream().mapToObj(var1 -> {
            int var2 = var1 & 0xF;
            int var3 = var1 >> 4 & 0xF;
            int var4 = var1 >> 8;
            return var0.getBlockAt(var2, var4 + this.minY, var3);
        });
    }

    public long[] toArray() {
        return this.mask.toLongArray();
    }

    public static interface Mask {
        public boolean test(int var1, int var2, int var3);
    }
}

