/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spigotmc.SpigotConfig;

public class ChunkStorage
implements AutoCloseable {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    private final IOWorker worker;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile LegacyStructureDataHandler legacyStructureHandler;

    public ChunkStorage(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag) {
        this.fixerUpper = datafixer;
        this.worker = new IOWorker(regionstorageinfo, path, flag);
    }

    public boolean isOldChunkAround(ChunkPos chunkcoordintpair, int i) {
        return this.worker.isOldChunkAround(chunkcoordintpair, i);
    }

    private boolean check(ServerChunkCache cps, int x, int z) {
        CompoundTag nbt;
        ChunkPos pos = new ChunkPos(x, z);
        if (cps != null && cps.hasChunk(x, z)) {
            return true;
        }
        try {
            nbt = this.read(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            CompoundTag level = nbt.getCompoundOrEmpty("Level");
            if (level.getBooleanOr("TerrainPopulated", false)) {
                return true;
            }
            ChunkStatus status = ChunkStatus.byName(level.getStringOr("Status", ""));
            if (status != null && status.isOrAfter(ChunkStatus.FEATURES)) {
                return true;
            }
        }
        return false;
    }

    public CompoundTag upgradeChunkTag(ResourceKey<LevelStem> resourcekey, Supplier<DimensionDataStorage> supplier, CompoundTag nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkPos pos, @Nullable LevelAccessor generatoraccess) {
        int i = ChunkStorage.getVersion(nbttagcompound);
        if (i == SharedConstants.getCurrentVersion().dataVersion().version()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            CompoundTag level;
            if (i < 1466 && (level = nbttagcompound.getCompoundOrEmpty("Level")).getBooleanOr("TerrainPopulated", false) && !level.getBooleanOr("LightPopulated", false)) {
                ServerChunkCache cps;
                ServerChunkCache serverChunkCache = cps = generatoraccess == null ? null : ((ServerLevel)generatoraccess).getChunkSource();
                if (this.check(cps, pos.x - 1, pos.z) && this.check(cps, pos.x - 1, pos.z - 1) && this.check(cps, pos.x, pos.z - 1)) {
                    level.putBoolean("LightPopulated", true);
                }
            }
            if (i < 1493 && (nbttagcompound = DataFixTypes.CHUNK.update(this.fixerUpper, nbttagcompound, i, 1493)).getCompound("Level").flatMap(nbttagcompound1 -> nbttagcompound1.getBoolean("hasLegacyStructureData")).orElse(false).booleanValue()) {
                LegacyStructureDataHandler persistentstructurelegacy = this.getLegacyStructureHandler(resourcekey, supplier);
                nbttagcompound = persistentstructurelegacy.updateFromLegacy(nbttagcompound);
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((ServerLevel)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.getCompoundOrEmpty("Level").getStringOr("Status", ""));
            }
            ChunkStorage.injectDatafixingContext(nbttagcompound, resourcekey, optional);
            nbttagcompound = DataFixTypes.CHUNK.updateToCurrentVersion(this.fixerUpper, nbttagcompound, Math.max(1493, i));
            if (stopBelowZero) {
                nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            ChunkStorage.removeDatafixingContext(nbttagcompound);
            NbtUtils.addCurrentDataVersion(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Updated chunk");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Updated chunk details");
            crashreportsystemdetails.setDetail("Data version", i);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacyStructureDataHandler getLegacyStructureHandler(ResourceKey<LevelStem> resourcekey, Supplier<DimensionDataStorage> supplier) {
        LegacyStructureDataHandler persistentstructurelegacy = this.legacyStructureHandler;
        if (persistentstructurelegacy == null) {
            ChunkStorage chunkStorage = this;
            synchronized (chunkStorage) {
                persistentstructurelegacy = this.legacyStructureHandler;
                if (persistentstructurelegacy == null) {
                    this.legacyStructureHandler = persistentstructurelegacy = LegacyStructureDataHandler.getLegacyStructureHandler(resourcekey, supplier.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void injectDatafixingContext(CompoundTag nbttagcompound, ResourceKey<LevelStem> resourcekey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional) {
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.putString("dimension", resourcekey.location().toString());
        optional.ifPresent(resourcekey1 -> nbttagcompound1.putString("generator", resourcekey1.location().toString()));
        nbttagcompound.put("__context", nbttagcompound1);
    }

    private static void removeDatafixingContext(CompoundTag nbttagcompound) {
        nbttagcompound.remove("__context");
    }

    public static int getVersion(CompoundTag nbttagcompound) {
        return NbtUtils.getDataVersion(nbttagcompound, -1);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkcoordintpair) {
        return this.worker.loadAsync(chunkcoordintpair);
    }

    public CompletableFuture<Void> write(ChunkPos chunkcoordintpair, Supplier<CompoundTag> supplier) {
        this.handleLegacyStructureIndex(chunkcoordintpair);
        return this.worker.store(chunkcoordintpair, supplier);
    }

    protected void handleLegacyStructureIndex(ChunkPos chunkcoordintpair) {
        if (this.legacyStructureHandler != null) {
            this.legacyStructureHandler.removeIndex(chunkcoordintpair.toLong());
        }
    }

    public void flushWorker() {
        this.worker.synchronize(true).join();
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public ChunkScanAccess chunkScanner() {
        return this.worker;
    }

    protected RegionStorageInfo storageInfo() {
        return this.worker.storageInfo();
    }
}

