/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.debug.DebugGameEventInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.GenericGameEvent;

public class GameEventDispatcher {
    private final ServerLevel level;

    public GameEventDispatcher(ServerLevel worldserver) {
        this.level = worldserver;
    }

    public void post(Holder<GameEvent> holder, Vec3 vec3d, GameEvent.Context gameevent_a) {
        int i = holder.value().notificationRadius();
        BlockPos blockposition = BlockPos.containing(vec3d);
        GenericGameEvent event = new GenericGameEvent(CraftGameEvent.minecraftToBukkit(holder.value()), CraftLocation.toBukkit(blockposition, (World)this.level.getWorld()), (Entity)(gameevent_a.sourceEntity() == null ? null : gameevent_a.sourceEntity().getBukkitEntity()), i, !Bukkit.isPrimaryThread());
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        i = event.getRadius();
        int j = SectionPos.blockToSectionCoord(blockposition.getX() - i);
        int k = SectionPos.blockToSectionCoord(blockposition.getY() - i);
        int l = SectionPos.blockToSectionCoord(blockposition.getZ() - i);
        int i1 = SectionPos.blockToSectionCoord(blockposition.getX() + i);
        int j1 = SectionPos.blockToSectionCoord(blockposition.getY() + i);
        int k1 = SectionPos.blockToSectionCoord(blockposition.getZ() + i);
        ArrayList<GameEvent.ListenerInfo> list = new ArrayList<GameEvent.ListenerInfo>();
        GameEventListenerRegistry.ListenerVisitor gameeventlistenerregistry_a = (gameeventlistener, vec3d1) -> {
            if (gameeventlistener.getDeliveryMode() == GameEventListener.DeliveryMode.BY_DISTANCE) {
                list.add(new GameEvent.ListenerInfo(holder, vec3d, gameevent_a, gameeventlistener, vec3d1));
            } else {
                gameeventlistener.handleGameEvent(this.level, holder, gameevent_a, vec3d);
            }
        };
        boolean flag = false;
        for (int l1 = j; l1 <= i1; ++l1) {
            for (int i2 = l; i2 <= k1; ++i2) {
                LevelChunk ichunkaccess = this.level.getChunkSource().getChunkNow(l1, i2);
                if (ichunkaccess == null) continue;
                for (int j2 = k; j2 <= j1; ++j2) {
                    flag |= ((ChunkAccess)ichunkaccess).getListenerRegistry(j2).visitInRangeListeners(holder, vec3d, gameevent_a, gameeventlistenerregistry_a);
                }
            }
        }
        if (!list.isEmpty()) {
            this.handleGameEventMessagesInQueue(list);
        }
        if (flag) {
            this.level.debugSynchronizers().broadcastEventToTracking(BlockPos.containing(vec3d), DebugSubscriptions.GAME_EVENTS, new DebugGameEventInfo(holder, vec3d));
        }
    }

    private void handleGameEventMessagesInQueue(List<GameEvent.ListenerInfo> list) {
        Collections.sort(list);
        for (GameEvent.ListenerInfo gameevent_b : list) {
            GameEventListener gameeventlistener = gameevent_b.recipient();
            gameeventlistener.handleGameEvent(this.level, gameevent_b.gameEvent(), gameevent_b.context(), gameevent_b.source());
        }
    }
}

