/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class DebugLevelSource
extends ChunkGenerator {
    public static final MapCodec<DebugLevelSource> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group(RegistryOps.retrieveElement(Biomes.PLAINS)).apply((Applicative)var0, var0.stable(DebugLevelSource::new)));
    private static final int BLOCK_MARGIN = 2;
    private static final List<BlockState> ALL_BLOCKS = StreamSupport.stream(BuiltInRegistries.BLOCK.spliterator(), false).flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).collect(Collectors.toList());
    private static final int GRID_WIDTH = Mth.ceil(Mth.sqrt(ALL_BLOCKS.size()));
    private static final int GRID_HEIGHT = Mth.ceil((float)ALL_BLOCKS.size() / (float)GRID_WIDTH);
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected static final BlockState BARRIER = Blocks.BARRIER.defaultBlockState();
    public static final int HEIGHT = 70;
    public static final int BARRIER_HEIGHT = 60;

    public DebugLevelSource(Holder.Reference<Biome> var0) {
        super(new FixedBiomeSource(var0));
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public void buildSurface(WorldGenRegion var0, StructureManager var1, RandomState var2, ChunkAccess var3) {
    }

    @Override
    public void applyBiomeDecoration(WorldGenLevel var0, ChunkAccess var1, StructureManager var2) {
        BlockPos.MutableBlockPos var3 = new BlockPos.MutableBlockPos();
        ChunkPos var4 = var1.getPos();
        int var5 = var4.x;
        int var6 = var4.z;
        for (int var7 = 0; var7 < 16; ++var7) {
            for (int var8 = 0; var8 < 16; ++var8) {
                int var9 = SectionPos.sectionToBlockCoord(var5, var7);
                int var10 = SectionPos.sectionToBlockCoord(var6, var8);
                var0.setBlock(var3.set(var9, 60, var10), BARRIER, 2);
                BlockState var11 = DebugLevelSource.getBlockStateFor(var9, var10);
                var0.setBlock(var3.set(var9, 70, var10), var11, 2);
            }
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> fillFromNoise(Blender var0, RandomState var1, StructureManager var2, ChunkAccess var3) {
        return CompletableFuture.completedFuture(var3);
    }

    @Override
    public int getBaseHeight(int var0, int var1, Heightmap.Types var2, LevelHeightAccessor var3, RandomState var4) {
        return 0;
    }

    @Override
    public NoiseColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2, RandomState var3) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    @Override
    public void addDebugScreenInfo(List<String> var0, RandomState var1, BlockPos var2) {
    }

    public static BlockState getBlockStateFor(int var0, int var1) {
        int var3;
        BlockState var2 = AIR;
        if (var0 > 0 && var1 > 0 && var0 % 2 != 0 && var1 % 2 != 0 && (var0 /= 2) <= GRID_WIDTH && (var1 /= 2) <= GRID_HEIGHT && (var3 = Mth.abs(var0 * GRID_WIDTH + var1)) < ALL_BLOCKS.size()) {
            var2 = ALL_BLOCKS.get(var3);
        }
        return var2;
    }

    @Override
    public void applyCarvers(WorldGenRegion var0, long var1, RandomState var3, BiomeManager var4, StructureManager var5, ChunkAccess var6) {
    }

    @Override
    public void spawnOriginalMobs(WorldGenRegion var0) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }
}

