/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.NetherWorldCarver;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldCarver<C extends CarverConfiguration> {
    public static final WorldCarver<CaveCarverConfiguration> CAVE = WorldCarver.register("cave", new CaveWorldCarver(CaveCarverConfiguration.CODEC));
    public static final WorldCarver<CaveCarverConfiguration> NETHER_CAVE = WorldCarver.register("nether_cave", new NetherWorldCarver(CaveCarverConfiguration.CODEC));
    public static final WorldCarver<CanyonCarverConfiguration> CANYON = WorldCarver.register("canyon", new CanyonWorldCarver(CanyonCarverConfiguration.CODEC));
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected static final FluidState WATER = Fluids.WATER.defaultFluidState();
    protected static final FluidState LAVA = Fluids.LAVA.defaultFluidState();
    protected Set<Fluid> liquids = ImmutableSet.of((Object)Fluids.WATER);
    private final MapCodec<ConfiguredWorldCarver<C>> configuredCodec;

    private static <C extends CarverConfiguration, F extends WorldCarver<C>> F register(String var0, F var1) {
        return (F)Registry.register(BuiltInRegistries.CARVER, var0, var1);
    }

    public WorldCarver(Codec<C> var0) {
        this.configuredCodec = var0.fieldOf("config").xmap(this::configured, ConfiguredWorldCarver::config);
    }

    public ConfiguredWorldCarver<C> configured(C var0) {
        return new ConfiguredWorldCarver<C>(this, var0);
    }

    public MapCodec<ConfiguredWorldCarver<C>> configuredCodec() {
        return this.configuredCodec;
    }

    public int getRange() {
        return 4;
    }

    protected boolean carveEllipsoid(CarvingContext var0, C var1, ChunkAccess var2, Function<BlockPos, Holder<Biome>> var3, Aquifer var4, double var5, double var7, double var9, double var11, double var13, CarvingMask var15, CarveSkipChecker var16) {
        ChunkPos var17 = var2.getPos();
        double var18 = var17.getMiddleBlockX();
        double var20 = var17.getMiddleBlockZ();
        double var22 = 16.0 + var11 * 2.0;
        if (Math.abs(var5 - var18) > var22 || Math.abs(var9 - var20) > var22) {
            return false;
        }
        int var24 = var17.getMinBlockX();
        int var25 = var17.getMinBlockZ();
        int var26 = Math.max(Mth.floor(var5 - var11) - var24 - 1, 0);
        int var27 = Math.min(Mth.floor(var5 + var11) - var24, 15);
        int var28 = Math.max(Mth.floor(var7 - var13) - 1, var0.getMinGenY() + 1);
        int var29 = var2.isUpgrading() ? 0 : 7;
        int var30 = Math.min(Mth.floor(var7 + var13) + 1, var0.getMinGenY() + var0.getGenDepth() - 1 - var29);
        int var31 = Math.max(Mth.floor(var9 - var11) - var25 - 1, 0);
        int var32 = Math.min(Mth.floor(var9 + var11) - var25, 15);
        boolean var33 = false;
        BlockPos.MutableBlockPos var34 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos var35 = new BlockPos.MutableBlockPos();
        for (int var36 = var26; var36 <= var27; ++var36) {
            int var37 = var17.getBlockX(var36);
            double var38 = ((double)var37 + 0.5 - var5) / var11;
            for (int var40 = var31; var40 <= var32; ++var40) {
                int var41 = var17.getBlockZ(var40);
                double var42 = ((double)var41 + 0.5 - var9) / var11;
                if (var38 * var38 + var42 * var42 >= 1.0) continue;
                MutableBoolean var44 = new MutableBoolean(false);
                for (int var45 = var30; var45 > var28; --var45) {
                    double var46 = ((double)var45 - 0.5 - var7) / var13;
                    if (var16.shouldSkip(var0, var38, var46, var42, var45) || var15.get(var36, var45, var40) && !WorldCarver.isDebugEnabled(var1)) continue;
                    var15.set(var36, var45, var40);
                    var34.set(var37, var45, var41);
                    var33 |= this.carveBlock(var0, var1, var2, var3, var15, var34, var35, var4, var44);
                }
            }
        }
        return var33;
    }

    protected boolean carveBlock(CarvingContext var0, C var1, ChunkAccess var22, Function<BlockPos, Holder<Biome>> var3, CarvingMask var4, BlockPos.MutableBlockPos var5, BlockPos.MutableBlockPos var6, Aquifer var7, MutableBoolean var8) {
        BlockState var9 = var22.getBlockState(var5);
        if (var9.is(Blocks.GRASS_BLOCK) || var9.is(Blocks.MYCELIUM)) {
            var8.setTrue();
        }
        if (!this.canReplaceBlock(var1, var9) && !WorldCarver.isDebugEnabled(var1)) {
            return false;
        }
        BlockState var10 = this.getCarveState(var0, var1, var5, var7);
        if (var10 == null) {
            return false;
        }
        var22.setBlockState(var5, var10);
        if (var7.shouldScheduleFluidUpdate() && !var10.getFluidState().isEmpty()) {
            var22.markPosForPostprocessing(var5);
        }
        if (var8.isTrue()) {
            var6.setWithOffset((Vec3i)var5, Direction.DOWN);
            if (var22.getBlockState(var6).is(Blocks.DIRT)) {
                var0.topMaterial(var3, var22, var6, !var10.getFluidState().isEmpty()).ifPresent(var2 -> {
                    var22.setBlockState(var6, (BlockState)var2);
                    if (!var2.getFluidState().isEmpty()) {
                        var22.markPosForPostprocessing(var6);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getCarveState(CarvingContext var0, C var1, BlockPos var2, Aquifer var3) {
        if (var2.getY() <= ((CarverConfiguration)var1).lavaLevel.resolveY(var0)) {
            return LAVA.createLegacyBlock();
        }
        BlockState var4 = var3.computeSubstance(new DensityFunction.SinglePointContext(var2.getX(), var2.getY(), var2.getZ()), 0.0);
        if (var4 == null) {
            return WorldCarver.isDebugEnabled(var1) ? ((CarverConfiguration)var1).debugSettings.getBarrierState() : null;
        }
        return WorldCarver.isDebugEnabled(var1) ? WorldCarver.getDebugState(var1, var4) : var4;
    }

    private static BlockState getDebugState(CarverConfiguration var0, BlockState var1) {
        if (var1.is(Blocks.AIR)) {
            return var0.debugSettings.getAirState();
        }
        if (var1.is(Blocks.WATER)) {
            BlockState var2 = var0.debugSettings.getWaterState();
            if (var2.hasProperty(BlockStateProperties.WATERLOGGED)) {
                return (BlockState)var2.setValue(BlockStateProperties.WATERLOGGED, true);
            }
            return var2;
        }
        if (var1.is(Blocks.LAVA)) {
            return var0.debugSettings.getLavaState();
        }
        return var1;
    }

    public abstract boolean carve(CarvingContext var1, C var2, ChunkAccess var3, Function<BlockPos, Holder<Biome>> var4, RandomSource var5, Aquifer var6, ChunkPos var7, CarvingMask var8);

    public abstract boolean isStartChunk(C var1, RandomSource var2);

    protected boolean canReplaceBlock(C var0, BlockState var1) {
        return var1.is(((CarverConfiguration)var0).replaceable);
    }

    protected static boolean canReach(ChunkPos var0, double var1, double var3, int var5, int var6, float var7) {
        double var18;
        double var16;
        double var10;
        double var14;
        double var8 = var0.getMiddleBlockX();
        double var12 = var1 - var8;
        return var12 * var12 + (var14 = var3 - (var10 = (double)var0.getMiddleBlockZ())) * var14 - (var16 = (double)(var6 - var5)) * var16 <= (var18 = (double)(var7 + 2.0f + 16.0f)) * var18;
    }

    private static boolean isDebugEnabled(CarverConfiguration var0) {
        return SharedConstants.DEBUG_CARVERS || var0.debugSettings.isDebugMode();
    }

    public static interface CarveSkipChecker {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

