/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;

public class BlockColumnFeature
extends Feature<BlockColumnConfiguration> {
    public BlockColumnFeature(Codec<BlockColumnConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<BlockColumnConfiguration> var0) {
        int var9;
        WorldGenLevel var1 = var0.level();
        BlockColumnConfiguration var2 = var0.config();
        RandomSource var3 = var0.random();
        int var4 = var2.layers().size();
        int[] var5 = new int[var4];
        int var6 = 0;
        for (int var7 = 0; var7 < var4; ++var7) {
            var5[var7] = var2.layers().get(var7).height().sample(var3);
            var6 += var5[var7];
        }
        if (var6 == 0) {
            return false;
        }
        BlockPos.MutableBlockPos var7 = var0.origin().mutable();
        BlockPos.MutableBlockPos var8 = var7.mutable().move(var2.direction());
        for (var9 = 0; var9 < var6; ++var9) {
            if (!var2.allowedPlacement().test(var1, var8)) {
                BlockColumnFeature.truncate(var5, var6, var9, var2.prioritizeTip());
                break;
            }
            var8.move(var2.direction());
        }
        for (var9 = 0; var9 < var4; ++var9) {
            int var10 = var5[var9];
            if (var10 == 0) continue;
            BlockColumnConfiguration.Layer var11 = var2.layers().get(var9);
            for (int var12 = 0; var12 < var10; ++var12) {
                var1.setBlock(var7, var11.state().getState(var3, var7), 2);
                var7.move(var2.direction());
            }
        }
        return true;
    }

    private static void truncate(int[] var0, int var1, int var2, boolean var3) {
        int var10;
        int var4 = var1 - var2;
        int var5 = var3 ? 1 : -1;
        int var6 = var3 ? 0 : var0.length - 1;
        int var7 = var3 ? var0.length : -1;
        for (int var8 = var6; var8 != var7 && var4 > 0; var4 -= var10, var8 += var5) {
            int var9 = var0[var8];
            var10 = Math.min(var9, var4);
            int n = var8;
            var0[n] = var0[n] - var10;
        }
    }
}

