/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;

public class MultifaceGrowthFeature
extends Feature<MultifaceGrowthConfiguration> {
    public MultifaceGrowthFeature(Codec<MultifaceGrowthConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<MultifaceGrowthConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        RandomSource var3 = var0.random();
        MultifaceGrowthConfiguration var4 = var0.config();
        if (!MultifaceGrowthFeature.isAirOrWater(var1.getBlockState(var2))) {
            return false;
        }
        List<Direction> var5 = var4.getShuffledDirections(var3);
        if (MultifaceGrowthFeature.placeGrowthIfPossible(var1, var2, var1.getBlockState(var2), var4, var3, var5)) {
            return true;
        }
        BlockPos.MutableBlockPos var6 = var2.mutable();
        block0: for (Direction var8 : var5) {
            var6.set(var2);
            List<Direction> var9 = var4.getShuffledDirectionsExcept(var3, var8.getOpposite());
            for (int var10 = 0; var10 < var4.searchRange; ++var10) {
                var6.setWithOffset((Vec3i)var2, var8);
                BlockState var11 = var1.getBlockState(var6);
                if (!MultifaceGrowthFeature.isAirOrWater(var11) && !var11.is(var4.placeBlock)) continue block0;
                if (!MultifaceGrowthFeature.placeGrowthIfPossible(var1, var6, var11, var4, var3, var9)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGrowthIfPossible(WorldGenLevel var0, BlockPos var1, BlockState var2, MultifaceGrowthConfiguration var3, RandomSource var4, List<Direction> var5) {
        BlockPos.MutableBlockPos var6 = var1.mutable();
        for (Direction var8 : var5) {
            BlockState var9 = var0.getBlockState(var6.setWithOffset((Vec3i)var1, var8));
            if (!var9.is(var3.canBePlacedOn)) continue;
            BlockState var10 = var3.placeBlock.getStateForPlacement(var2, var0, var1, var8);
            if (var10 == null) {
                return false;
            }
            var0.setBlock(var1, var10, 3);
            var0.getChunk(var1).markPosForPostprocessing(var1);
            if (var4.nextFloat() < var3.chanceOfSpreading) {
                var3.placeBlock.getSpreader().spreadFromFaceTowardRandomDirection(var10, var0, var1, var8, var4, true);
            }
            return true;
        }
        return false;
    }

    private static boolean isAirOrWater(BlockState var0) {
        return var0.isAir() || var0.is(Blocks.WATER);
    }
}

