/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WeepingVinesFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public WeepingVinesFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        RandomSource var3 = var0.random();
        if (!var1.isEmptyBlock(var2)) {
            return false;
        }
        BlockState var4 = var1.getBlockState(var2.above());
        if (!var4.is(Blocks.NETHERRACK) && !var4.is(Blocks.NETHER_WART_BLOCK)) {
            return false;
        }
        this.placeRoofNetherWart(var1, var3, var2);
        this.placeRoofWeepingVines(var1, var3, var2);
        return true;
    }

    private void placeRoofNetherWart(LevelAccessor var0, RandomSource var1, BlockPos var2) {
        var0.setBlock(var2, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos var3 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (int var5 = 0; var5 < 200; ++var5) {
            var3.setWithOffset(var2, var1.nextInt(6) - var1.nextInt(6), var1.nextInt(2) - var1.nextInt(5), var1.nextInt(6) - var1.nextInt(6));
            if (!var0.isEmptyBlock(var3)) continue;
            int var6 = 0;
            for (Direction var10 : DIRECTIONS) {
                BlockState var11 = var0.getBlockState(var4.setWithOffset((Vec3i)var3, var10));
                if (var11.is(Blocks.NETHERRACK) || var11.is(Blocks.NETHER_WART_BLOCK)) {
                    ++var6;
                }
                if (var6 > 1) break;
            }
            if (var6 != true) continue;
            var0.setBlock(var3, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
        }
    }

    private void placeRoofWeepingVines(LevelAccessor var0, RandomSource var1, BlockPos var2) {
        BlockPos.MutableBlockPos var3 = new BlockPos.MutableBlockPos();
        for (int var4 = 0; var4 < 100; ++var4) {
            BlockState var5;
            var3.setWithOffset(var2, var1.nextInt(8) - var1.nextInt(8), var1.nextInt(2) - var1.nextInt(7), var1.nextInt(8) - var1.nextInt(8));
            if (!var0.isEmptyBlock(var3) || !(var5 = var0.getBlockState((BlockPos)var3.above())).is(Blocks.NETHERRACK) && !var5.is(Blocks.NETHER_WART_BLOCK)) continue;
            int var6 = Mth.nextInt(var1, 1, 8);
            if (var1.nextInt(6) == 0) {
                var6 *= 2;
            }
            if (var1.nextInt(5) == 0) {
                var6 = 1;
            }
            int var7 = 17;
            int var8 = 25;
            WeepingVinesFeature.placeWeepingVinesColumn(var0, var1, var3, var6, 17, 25);
        }
    }

    public static void placeWeepingVinesColumn(LevelAccessor var0, RandomSource var1, BlockPos.MutableBlockPos var2, int var3, int var4, int var5) {
        for (int var6 = 0; var6 <= var3; ++var6) {
            if (var0.isEmptyBlock(var2)) {
                if (var6 == var3 || !var0.isEmptyBlock((BlockPos)var2.below())) {
                    var0.setBlock(var2, (BlockState)Blocks.WEEPING_VINES.defaultBlockState().setValue(GrowingPlantHeadBlock.AGE, Mth.nextInt(var1, var4, var5)), 2);
                    break;
                }
                var0.setBlock(var2, Blocks.WEEPING_VINES_PLANT.defaultBlockState(), 2);
            }
            var2.move(Direction.DOWN);
        }
    }
}

