/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class RandomSpreadFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<RandomSpreadFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> RandomSpreadFoliagePlacer.foliagePlacerParts(var02).and(var02.group((App)IntProvider.codec(1, 512).fieldOf("foliage_height").forGetter(var0 -> var0.foliageHeight), (App)Codec.intRange((int)0, (int)256).fieldOf("leaf_placement_attempts").forGetter(var0 -> var0.leafPlacementAttempts))).apply((Applicative)var02, RandomSpreadFoliagePlacer::new));
    private final IntProvider foliageHeight;
    private final int leafPlacementAttempts;

    public RandomSpreadFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2, int var3) {
        super(var0, var1);
        this.foliageHeight = var2;
        this.leafPlacementAttempts = var3;
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.RANDOM_SPREAD_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        BlockPos var9 = var5.pos();
        BlockPos.MutableBlockPos var10 = var9.mutable();
        for (int var11 = 0; var11 < this.leafPlacementAttempts; ++var11) {
            var10.setWithOffset(var9, var2.nextInt(var7) - var2.nextInt(var7), var2.nextInt(var6) - var2.nextInt(var6), var2.nextInt(var7) - var2.nextInt(var7));
            RandomSpreadFoliagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var10);
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return this.foliageHeight.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return false;
    }
}

