/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class JigsawStructure
extends Structure {
    public static final DimensionPadding DEFAULT_DIMENSION_PADDING = DimensionPadding.ZERO;
    public static final LiquidSettings DEFAULT_LIQUID_SETTINGS = LiquidSettings.APPLY_WATERLOGGING;
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final int MIN_DEPTH = 0;
    public static final int MAX_DEPTH = 20;
    public static final MapCodec<JigsawStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(JigsawStructure.settingsCodec(var02), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(var0 -> var0.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(var0 -> var0.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(var0 -> var0.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(var0 -> var0.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(var0 -> var0.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(var0 -> var0.projectStartToHeightmap), (App)MaxDistance.CODEC.fieldOf("max_distance_from_center").forGetter(var0 -> var0.maxDistanceFromCenter), (App)Codec.list(PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(var0 -> var0.poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DEFAULT_DIMENSION_PADDING).forGetter(var0 -> var0.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)DEFAULT_LIQUID_SETTINGS).forGetter(var0 -> var0.liquidSettings)).apply((Applicative)var02, JigsawStructure::new)).validate(JigsawStructure::verifyRange);
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final MaxDistance maxDistanceFromCenter;
    private final List<PoolAliasBinding> poolAliases;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    private static DataResult<JigsawStructure> verifyRange(JigsawStructure var0) {
        int var1;
        switch (var0.terrainAdaptation()) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                int n = 0;
                break;
            }
            case BURY: 
            case BEARD_THIN: 
            case BEARD_BOX: 
            case ENCAPSULATE: {
                int n = var1 = 12;
            }
        }
        if (var0.maxDistanceFromCenter.horizontal() + var1 > 128) {
            return DataResult.error(() -> "Horizontal structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)var0);
    }

    public JigsawStructure(Structure.StructureSettings var0, Holder<StructureTemplatePool> var1, Optional<ResourceLocation> var2, int var3, HeightProvider var4, boolean var5, Optional<Heightmap.Types> var6, MaxDistance var7, List<PoolAliasBinding> var8, DimensionPadding var9, LiquidSettings var10) {
        super(var0);
        this.startPool = var1;
        this.startJigsawName = var2;
        this.maxDepth = var3;
        this.startHeight = var4;
        this.useExpansionHack = var5;
        this.projectStartToHeightmap = var6;
        this.maxDistanceFromCenter = var7;
        this.poolAliases = var8;
        this.dimensionPadding = var9;
        this.liquidSettings = var10;
    }

    public JigsawStructure(Structure.StructureSettings var0, Holder<StructureTemplatePool> var1, int var2, HeightProvider var3, boolean var4, Heightmap.Types var5) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.of(var5), new MaxDistance(80), List.of(), DEFAULT_DIMENSION_PADDING, DEFAULT_LIQUID_SETTINGS);
    }

    public JigsawStructure(Structure.StructureSettings var0, Holder<StructureTemplatePool> var1, int var2, HeightProvider var3, boolean var4) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.empty(), new MaxDistance(80), List.of(), DEFAULT_DIMENSION_PADDING, DEFAULT_LIQUID_SETTINGS);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        ChunkPos var1 = var0.chunkPos();
        int var2 = this.startHeight.sample(var0.random(), new WorldGenerationContext(var0.chunkGenerator(), var0.heightAccessor()));
        BlockPos var3 = new BlockPos(var1.getMinBlockX(), var2, var1.getMinBlockZ());
        return JigsawPlacement.addPieces(var0, this.startPool, this.startJigsawName, this.maxDepth, var3, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, PoolAliasLookup.create(this.poolAliases, var3, var0.seed()), this.dimensionPadding, this.liquidSettings);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.JIGSAW;
    }

    @VisibleForTesting
    public Holder<StructureTemplatePool> getStartPool() {
        return this.startPool;
    }

    @VisibleForTesting
    public List<PoolAliasBinding> getPoolAliases() {
        return this.poolAliases;
    }

    public record MaxDistance(int horizontal, int vertical) {
        private static final Codec<Integer> HORIZONTAL_VALUE_CODEC = Codec.intRange((int)1, (int)128);
        private static final Codec<MaxDistance> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)HORIZONTAL_VALUE_CODEC.fieldOf("horizontal").forGetter(MaxDistance::horizontal), (App)ExtraCodecs.intRange(1, DimensionType.Y_SIZE).optionalFieldOf("vertical", (Object)DimensionType.Y_SIZE).forGetter(MaxDistance::vertical)).apply((Applicative)var0, MaxDistance::new));
        public static final Codec<MaxDistance> CODEC = Codec.either(FULL_CODEC, HORIZONTAL_VALUE_CODEC).xmap(var0 -> (MaxDistance)var0.map(Function.identity(), MaxDistance::new), var0 -> var0.horizontal == var0.vertical ? Either.right((Object)var0.horizontal) : Either.left((Object)var0));

        public MaxDistance(int var0) {
            this(var0, var0);
        }
    }
}

