/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import org.jetbrains.annotations.VisibleForTesting;

public final class SkyLightEngine
extends LightEngine<SkyLightSectionStorage.SkyDataLayerStorageMap, SkyLightSectionStorage> {
    private static final long REMOVE_TOP_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.decreaseAllDirections(15);
    private static final long REMOVE_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.decreaseSkipOneDirection(15, Direction.UP);
    private static final long ADD_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.increaseSkipOneDirection(15, false, Direction.UP);
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final ChunkSkyLightSources emptyChunkSources;

    public SkyLightEngine(LightChunkGetter var0) {
        this(var0, new SkyLightSectionStorage(var0));
    }

    @VisibleForTesting
    protected SkyLightEngine(LightChunkGetter var0, SkyLightSectionStorage var1) {
        super(var0, var1);
        this.emptyChunkSources = new ChunkSkyLightSources(var0.getLevel());
    }

    private static boolean isSourceLevel(int var0) {
        return var0 == 15;
    }

    private int getLowestSourceY(int var0, int var1, int var2) {
        ChunkSkyLightSources var3 = this.getChunkSources(SectionPos.blockToSectionCoord(var0), SectionPos.blockToSectionCoord(var1));
        if (var3 == null) {
            return var2;
        }
        return var3.getLowestSourceY(SectionPos.sectionRelative(var0), SectionPos.sectionRelative(var1));
    }

    @Nullable
    private ChunkSkyLightSources getChunkSources(int var0, int var1) {
        LightChunk var2 = this.chunkSource.getChunkForLighting(var0, var1);
        return var2 != null ? var2.getSkyLightSources() : null;
    }

    @Override
    protected void checkNode(long var0) {
        boolean var8;
        int var7;
        int var2 = BlockPos.getX(var0);
        int var3 = BlockPos.getY(var0);
        int var4 = BlockPos.getZ(var0);
        long var5 = SectionPos.blockToSection(var0);
        int n = var7 = ((SkyLightSectionStorage)this.storage).lightOnInSection(var5) ? this.getLowestSourceY(var2, var4, Integer.MAX_VALUE) : Integer.MAX_VALUE;
        if (var7 != Integer.MAX_VALUE) {
            this.updateSourcesInColumn(var2, var4, var7);
        }
        if (!((SkyLightSectionStorage)this.storage).storingLightForSection(var5)) {
            return;
        }
        boolean bl = var8 = var3 >= var7;
        if (var8) {
            this.enqueueDecrease(var0, REMOVE_SKY_SOURCE_ENTRY);
            this.enqueueIncrease(var0, ADD_SKY_SOURCE_ENTRY);
        } else {
            int var9 = ((SkyLightSectionStorage)this.storage).getStoredLevel(var0);
            if (var9 > 0) {
                ((SkyLightSectionStorage)this.storage).setStoredLevel(var0, 0);
                this.enqueueDecrease(var0, LightEngine.QueueEntry.decreaseAllDirections(var9));
            } else {
                this.enqueueDecrease(var0, PULL_LIGHT_IN_ENTRY);
            }
        }
    }

    private void updateSourcesInColumn(int var0, int var1, int var2) {
        int var3 = SectionPos.sectionToBlockCoord(((SkyLightSectionStorage)this.storage).getBottomSectionY());
        this.removeSourcesBelow(var0, var1, var2, var3);
        this.addSourcesAbove(var0, var1, var2, var3);
    }

    private void removeSourcesBelow(int var0, int var1, int var2, int var3) {
        if (var2 <= var3) {
            return;
        }
        int var4 = SectionPos.blockToSectionCoord(var0);
        int var5 = SectionPos.blockToSectionCoord(var1);
        int var6 = var2 - 1;
        int var7 = SectionPos.blockToSectionCoord(var6);
        while (((SkyLightSectionStorage)this.storage).hasLightDataAtOrBelow(var7)) {
            if (((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong(var4, var7, var5))) {
                int var8 = SectionPos.sectionToBlockCoord(var7);
                int var9 = var8 + 15;
                for (int var10 = Math.min(var9, var6); var10 >= var8; --var10) {
                    long var11 = BlockPos.asLong(var0, var10, var1);
                    if (!SkyLightEngine.isSourceLevel(((SkyLightSectionStorage)this.storage).getStoredLevel(var11))) {
                        return;
                    }
                    ((SkyLightSectionStorage)this.storage).setStoredLevel(var11, 0);
                    this.enqueueDecrease(var11, var10 == var2 - 1 ? REMOVE_TOP_SKY_SOURCE_ENTRY : REMOVE_SKY_SOURCE_ENTRY);
                }
            }
            --var7;
        }
    }

    private void addSourcesAbove(int var0, int var1, int var2, int var3) {
        int var4 = SectionPos.blockToSectionCoord(var0);
        int var5 = SectionPos.blockToSectionCoord(var1);
        int var6 = Math.max(Math.max(this.getLowestSourceY(var0 - 1, var1, Integer.MIN_VALUE), this.getLowestSourceY(var0 + 1, var1, Integer.MIN_VALUE)), Math.max(this.getLowestSourceY(var0, var1 - 1, Integer.MIN_VALUE), this.getLowestSourceY(var0, var1 + 1, Integer.MIN_VALUE)));
        int var7 = Math.max(var2, var3);
        long var8 = SectionPos.asLong(var4, SectionPos.blockToSectionCoord(var7), var5);
        while (!((SkyLightSectionStorage)this.storage).isAboveData(var8)) {
            if (((SkyLightSectionStorage)this.storage).storingLightForSection(var8)) {
                int var10 = SectionPos.sectionToBlockCoord(SectionPos.y(var8));
                int var11 = var10 + 15;
                for (int var12 = Math.max(var10, var7); var12 <= var11; ++var12) {
                    long var13 = BlockPos.asLong(var0, var12, var1);
                    if (SkyLightEngine.isSourceLevel(((SkyLightSectionStorage)this.storage).getStoredLevel(var13))) {
                        return;
                    }
                    ((SkyLightSectionStorage)this.storage).setStoredLevel(var13, 15);
                    if (var12 >= var6 && var12 != var2) continue;
                    this.enqueueIncrease(var13, ADD_SKY_SOURCE_ENTRY);
                }
            }
            var8 = SectionPos.offset(var8, Direction.UP);
        }
    }

    @Override
    protected void propagateIncrease(long var0, long var2, int var4) {
        BlockState var5 = null;
        int var6 = this.countEmptySectionsBelowIfAtBorder(var0);
        for (Direction var10 : PROPAGATION_DIRECTIONS) {
            int var13;
            int var14;
            long var11;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(var2, var10) || !((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(var11 = BlockPos.offset(var0, var10))) || (var14 = var4 - 1) <= (var13 = ((SkyLightSectionStorage)this.storage).getStoredLevel(var11))) continue;
            this.mutablePos.set(var11);
            BlockState var15 = this.getState(this.mutablePos);
            int var16 = var4 - this.getOpacity(var15);
            if (var16 <= var13) continue;
            if (var5 == null) {
                BlockState blockState = var5 = LightEngine.QueueEntry.isFromEmptyShape(var2) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(var0));
            }
            if (this.shapeOccludes(var5, var15, var10)) continue;
            ((SkyLightSectionStorage)this.storage).setStoredLevel(var11, var16);
            if (var16 > 1) {
                this.enqueueIncrease(var11, LightEngine.QueueEntry.increaseSkipOneDirection(var16, SkyLightEngine.isEmptyShape(var15), var10.getOpposite()));
            }
            this.propagateFromEmptySections(var11, var10, var16, true, var6);
        }
    }

    @Override
    protected void propagateDecrease(long var0, long var2) {
        int var4 = this.countEmptySectionsBelowIfAtBorder(var0);
        int var5 = LightEngine.QueueEntry.getFromLevel(var2);
        for (Direction var9 : PROPAGATION_DIRECTIONS) {
            int var12;
            long var10;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(var2, var9) || !((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(var10 = BlockPos.offset(var0, var9))) || (var12 = ((SkyLightSectionStorage)this.storage).getStoredLevel(var10)) == 0) continue;
            if (var12 <= var5 - 1) {
                ((SkyLightSectionStorage)this.storage).setStoredLevel(var10, 0);
                this.enqueueDecrease(var10, LightEngine.QueueEntry.decreaseSkipOneDirection(var12, var9.getOpposite()));
                this.propagateFromEmptySections(var10, var9, var12, false, var4);
                continue;
            }
            this.enqueueIncrease(var10, LightEngine.QueueEntry.increaseOnlyOneDirection(var12, false, var9.getOpposite()));
        }
    }

    private int countEmptySectionsBelowIfAtBorder(long var0) {
        int var2 = BlockPos.getY(var0);
        int var3 = SectionPos.sectionRelative(var2);
        if (var3 != 0) {
            return 0;
        }
        int var4 = BlockPos.getX(var0);
        int var5 = BlockPos.getZ(var0);
        int var6 = SectionPos.sectionRelative(var4);
        int var7 = SectionPos.sectionRelative(var5);
        if (var6 == 0 || var6 == 15 || var7 == 0 || var7 == 15) {
            int var8 = SectionPos.blockToSectionCoord(var4);
            int var9 = SectionPos.blockToSectionCoord(var2);
            int var10 = SectionPos.blockToSectionCoord(var5);
            int var11 = 0;
            while (!((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong(var8, var9 - var11 - 1, var10)) && ((SkyLightSectionStorage)this.storage).hasLightDataAtOrBelow(var9 - var11 - 1)) {
                ++var11;
            }
            return var11;
        }
        return 0;
    }

    private void propagateFromEmptySections(long var0, Direction var2, int var3, boolean var4, int var5) {
        if (var5 == 0) {
            return;
        }
        int var6 = BlockPos.getX(var0);
        int var7 = BlockPos.getZ(var0);
        if (!SkyLightEngine.crossedSectionEdge(var2, SectionPos.sectionRelative(var6), SectionPos.sectionRelative(var7))) {
            return;
        }
        int var8 = BlockPos.getY(var0);
        int var9 = SectionPos.blockToSectionCoord(var6);
        int var10 = SectionPos.blockToSectionCoord(var7);
        int var11 = SectionPos.blockToSectionCoord(var8) - 1;
        int var12 = var11 - var5 + 1;
        while (var11 >= var12) {
            if (!((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong(var9, var11, var10))) {
                --var11;
                continue;
            }
            int var13 = SectionPos.sectionToBlockCoord(var11);
            for (int var14 = 15; var14 >= 0; --var14) {
                long var15 = BlockPos.asLong(var6, var13 + var14, var7);
                if (var4) {
                    ((SkyLightSectionStorage)this.storage).setStoredLevel(var15, var3);
                    if (var3 <= 1) continue;
                    this.enqueueIncrease(var15, LightEngine.QueueEntry.increaseSkipOneDirection(var3, true, var2.getOpposite()));
                    continue;
                }
                ((SkyLightSectionStorage)this.storage).setStoredLevel(var15, 0);
                this.enqueueDecrease(var15, LightEngine.QueueEntry.decreaseSkipOneDirection(var3, var2.getOpposite()));
            }
            --var11;
        }
    }

    private static boolean crossedSectionEdge(Direction var0, int var1, int var2) {
        return switch (var0) {
            case Direction.NORTH -> {
                if (var2 == 15) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (var2 == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (var1 == 15) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (var1 == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void setLightEnabled(ChunkPos var0, boolean var1) {
        super.setLightEnabled(var0, var1);
        if (var1) {
            ChunkSkyLightSources var2 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z), this.emptyChunkSources);
            int var3 = var2.getHighestLowestSourceY() - 1;
            int var4 = SectionPos.blockToSectionCoord(var3) + 1;
            long var5 = SectionPos.getZeroNode(var0.x, var0.z);
            int var7 = ((SkyLightSectionStorage)this.storage).getTopSectionY(var5);
            int var8 = Math.max(((SkyLightSectionStorage)this.storage).getBottomSectionY(), var4);
            for (int var9 = var7 - 1; var9 >= var8; --var9) {
                DataLayer var10 = ((SkyLightSectionStorage)this.storage).getDataLayerToWrite(SectionPos.asLong(var0.x, var9, var0.z));
                if (var10 == null || !var10.isEmpty()) continue;
                var10.fill(15);
            }
        }
    }

    @Override
    public void propagateLightSources(ChunkPos var0) {
        long var1 = SectionPos.getZeroNode(var0.x, var0.z);
        ((SkyLightSectionStorage)this.storage).setLightEnabled(var1, true);
        ChunkSkyLightSources var3 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z), this.emptyChunkSources);
        ChunkSkyLightSources var4 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z - 1), this.emptyChunkSources);
        ChunkSkyLightSources var5 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z + 1), this.emptyChunkSources);
        ChunkSkyLightSources var6 = Objects.requireNonNullElse(this.getChunkSources(var0.x - 1, var0.z), this.emptyChunkSources);
        ChunkSkyLightSources var7 = Objects.requireNonNullElse(this.getChunkSources(var0.x + 1, var0.z), this.emptyChunkSources);
        int var8 = ((SkyLightSectionStorage)this.storage).getTopSectionY(var1);
        int var9 = ((SkyLightSectionStorage)this.storage).getBottomSectionY();
        int var10 = SectionPos.sectionToBlockCoord(var0.x);
        int var11 = SectionPos.sectionToBlockCoord(var0.z);
        for (int var12 = var8 - 1; var12 >= var9; --var12) {
            long var13 = SectionPos.asLong(var0.x, var12, var0.z);
            DataLayer var15 = ((SkyLightSectionStorage)this.storage).getDataLayerToWrite(var13);
            if (var15 == null) continue;
            int var16 = SectionPos.sectionToBlockCoord(var12);
            int var17 = var16 + 15;
            boolean var18 = false;
            for (int var19 = 0; var19 < 16; ++var19) {
                for (int var20 = 0; var20 < 16; ++var20) {
                    int var21 = var3.getLowestSourceY(var20, var19);
                    if (var21 > var17) continue;
                    int var22 = var19 == 0 ? var4.getLowestSourceY(var20, 15) : var3.getLowestSourceY(var20, var19 - 1);
                    int var23 = var19 == 15 ? var5.getLowestSourceY(var20, 0) : var3.getLowestSourceY(var20, var19 + 1);
                    int var24 = var20 == 0 ? var6.getLowestSourceY(15, var19) : var3.getLowestSourceY(var20 - 1, var19);
                    int var25 = var20 == 15 ? var7.getLowestSourceY(0, var19) : var3.getLowestSourceY(var20 + 1, var19);
                    int var26 = Math.max(Math.max(var22, var23), Math.max(var24, var25));
                    for (int var27 = var17; var27 >= Math.max(var16, var21); --var27) {
                        var15.set(var20, SectionPos.sectionRelative(var27), var19, 15);
                        if (var27 != var21 && var27 >= var26) continue;
                        long var28 = BlockPos.asLong(var10 + var20, var27, var11 + var19);
                        this.enqueueIncrease(var28, LightEngine.QueueEntry.increaseSkySourceInDirections(var27 == var21, var27 < var22, var27 < var23, var27 < var24, var27 < var25));
                    }
                    if (var21 >= var16) continue;
                    var18 = true;
                }
            }
            if (!var18) break;
        }
    }
}

