/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.Vec3;

public final class Path {
    public static final StreamCodec<FriendlyByteBuf, Path> STREAM_CODEC = StreamCodec.of((var0, var1) -> var1.writeToStream((FriendlyByteBuf)((Object)var0)), Path::createFromStream);
    private final List<Node> nodes;
    @Nullable
    private DebugData debugData;
    private int nextNodeIndex;
    private final BlockPos target;
    private final float distToTarget;
    private final boolean reached;

    public Path(List<Node> var0, BlockPos var1, boolean var2) {
        this.nodes = var0;
        this.target = var1;
        this.distToTarget = var0.isEmpty() ? Float.MAX_VALUE : this.nodes.get(this.nodes.size() - 1).distanceManhattan(this.target);
        this.reached = var2;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public Node getEndNode() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public Node getNode(int var0) {
        return this.nodes.get(var0);
    }

    public void truncateNodes(int var0) {
        if (this.nodes.size() > var0) {
            this.nodes.subList(var0, this.nodes.size()).clear();
        }
    }

    public void replaceNode(int var0, Node var1) {
        this.nodes.set(var0, var1);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setNextNodeIndex(int var0) {
        this.nextNodeIndex = var0;
    }

    public Vec3 getEntityPosAtNode(Entity var0, int var1) {
        Node var2 = this.nodes.get(var1);
        double var3 = (double)var2.x + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        double var5 = var2.y;
        double var7 = (double)var2.z + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        return new Vec3(var3, var5, var7);
    }

    public BlockPos getNodePos(int var0) {
        return this.nodes.get(var0).asBlockPos();
    }

    public Vec3 getNextEntityPos(Entity var0) {
        return this.getEntityPosAtNode(var0, this.nextNodeIndex);
    }

    public BlockPos getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public Node getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public Node getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable Path var0) {
        return var0 != null && this.nodes.equals(var0.nodes);
    }

    public boolean equals(Object var0) {
        if (!(var0 instanceof Path)) {
            return false;
        }
        Path var1 = (Path)var0;
        return this.nextNodeIndex == var1.nextNodeIndex && this.debugData == var1.debugData && this.reached == var1.reached && this.target.equals(var1.target) && this.nodes.equals(var1.nodes);
    }

    public int hashCode() {
        return this.nextNodeIndex + this.nodes.hashCode() * 31;
    }

    public boolean canReach() {
        return this.reached;
    }

    @VisibleForDebug
    void setDebug(Node[] var0, Node[] var1, Set<Target> var2) {
        this.debugData = new DebugData(var0, var1, var2);
    }

    @Nullable
    public DebugData debugData() {
        return this.debugData;
    }

    public void writeToStream(FriendlyByteBuf var02) {
        if (this.debugData == null || this.debugData.targetNodes.isEmpty()) {
            throw new IllegalStateException("Missing debug data");
        }
        var02.writeBoolean(this.reached);
        var02.writeInt(this.nextNodeIndex);
        var02.writeBlockPos(this.target);
        var02.writeCollection(this.nodes, (var0, var1) -> var1.writeToStream((FriendlyByteBuf)((Object)var0)));
        this.debugData.write(var02);
    }

    public static Path createFromStream(FriendlyByteBuf var0) {
        boolean var1 = var0.readBoolean();
        int var2 = var0.readInt();
        BlockPos var3 = var0.readBlockPos();
        List<Node> var4 = var0.readList(Node::createFromStream);
        DebugData var5 = DebugData.read(var0);
        Path var6 = new Path(var4, var3, var1);
        var6.debugData = var5;
        var6.nextNodeIndex = var2;
        return var6;
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }

    static Node[] readNodeArray(FriendlyByteBuf var0) {
        Node[] var1 = new Node[var0.readVarInt()];
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = Node.createFromStream(var0);
        }
        return var1;
    }

    static void writeNodeArray(FriendlyByteBuf var0, Node[] var1) {
        var0.writeVarInt(var1.length);
        for (Node var5 : var1) {
            var5.writeToStream(var0);
        }
    }

    public Path copy() {
        Path var0 = new Path(this.nodes, this.target, this.reached);
        var0.debugData = this.debugData;
        var0.nextNodeIndex = this.nextNodeIndex;
        return var0;
    }

    public static final class DebugData
    extends Record {
        private final Node[] openSet;
        private final Node[] closedSet;
        final Set<Target> targetNodes;

        public DebugData(Node[] var0, Node[] var1, Set<Target> var2) {
            this.openSet = var0;
            this.closedSet = var1;
            this.targetNodes = var2;
        }

        public void write(FriendlyByteBuf var02) {
            var02.writeCollection(this.targetNodes, (var0, var1) -> var1.writeToStream((FriendlyByteBuf)((Object)var0)));
            Path.writeNodeArray(var02, this.openSet);
            Path.writeNodeArray(var02, this.closedSet);
        }

        public static DebugData read(FriendlyByteBuf var0) {
            HashSet var1 = var0.readCollection(HashSet::new, Target::createFromStream);
            Node[] var2 = Path.readNodeArray(var0);
            Node[] var3 = Path.readNodeArray(var0);
            return new DebugData(var2, var3, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DebugData.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DebugData.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DebugData.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this, var0);
        }

        public Node[] openSet() {
            return this.openSet;
        }

        public Node[] closedSet() {
            return this.closedSet;
        }

        public Set<Target> targetNodes() {
            return this.targetNodes;
        }
    }
}

