/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class EnchantedCountIncreaseFunction
extends LootItemConditionalFunction {
    public static final int NO_LIMIT = 0;
    public static final MapCodec<EnchantedCountIncreaseFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> EnchantedCountIncreaseFunction.commonFields(var02).and(var02.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(var0 -> var0.enchantment), (App)NumberProviders.CODEC.fieldOf("count").forGetter(var0 -> var0.value), (App)Codec.INT.optionalFieldOf("limit", (Object)0).forGetter(var0 -> var0.limit))).apply((Applicative)var02, EnchantedCountIncreaseFunction::new));
    private final Holder<Enchantment> enchantment;
    private final NumberProvider value;
    private final int limit;

    EnchantedCountIncreaseFunction(List<LootItemCondition> var0, Holder<Enchantment> var1, NumberProvider var2, int var3) {
        super(var0);
        this.enchantment = var1;
        this.value = var2;
        this.limit = var3;
    }

    public LootItemFunctionType<EnchantedCountIncreaseFunction> getType() {
        return LootItemFunctions.ENCHANTED_COUNT_INCREASE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Sets.union((Set)ImmutableSet.of(LootContextParams.ATTACKING_ENTITY), this.value.getReferencedContextParams());
    }

    private boolean hasLimit() {
        return this.limit > 0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Entity var2 = var1.getOptionalParameter(LootContextParams.ATTACKING_ENTITY);
        if (var2 instanceof LivingEntity) {
            LivingEntity var3 = (LivingEntity)var2;
            int var4 = EnchantmentHelper.getEnchantmentLevel(this.enchantment, var3);
            if (var4 == 0) {
                return var0;
            }
            float var5 = (float)var4 * this.value.getFloat(var1);
            var0.grow(Math.round(var5));
            if (this.hasLimit()) {
                var0.limitSize(this.limit);
            }
        }
        return var0;
    }

    public static Builder lootingMultiplier(HolderLookup.Provider var0, NumberProvider var1) {
        HolderGetter var2 = var0.lookupOrThrow(Registries.ENCHANTMENT);
        return new Builder(var2.getOrThrow(Enchantments.LOOTING), var1);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Holder<Enchantment> enchantment;
        private final NumberProvider count;
        private int limit = 0;

        public Builder(Holder<Enchantment> var0, NumberProvider var1) {
            this.enchantment = var0;
            this.count = var1;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setLimit(int var0) {
            this.limit = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantedCountIncreaseFunction(this.getConditions(), this.enchantment, this.count, this.limit);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

