/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.BaseCoralFanBlock;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConduitBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DriedGhastBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HeavyCoreBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.MangroveLeavesBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PiglinWallSkullBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.PlayerWallHeadBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.WeatheringCopperBarsBlock;
import net.minecraft.world.level.block.WeatheringCopperBulbBlock;
import net.minecraft.world.level.block.WeatheringCopperChainBlock;
import net.minecraft.world.level.block.WeatheringCopperChestBlock;
import net.minecraft.world.level.block.WeatheringCopperDoorBlock;
import net.minecraft.world.level.block.WeatheringCopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopperGrateBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WeatheringCopperTrapDoorBlock;
import net.minecraft.world.level.block.WeatheringLanternBlock;
import net.minecraft.world.level.block.WeatheringLightningRodBlock;
import net.minecraft.world.level.block.WeepingVinesBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.WitherWallSkullBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.BlockType;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockStateEnum;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBarrier;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBrushable;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperBulb;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDriedGhast;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFlowerBed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHangingMoss;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHeavyCore;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLeafLitter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMossyCarpet;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMultiface;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPitcherCrop;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSnifferEgg;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftUntintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftVault;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWaterloggedTransparent;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperBars;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperBulb;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperChain;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperGrate;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperTrapDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringLantern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringLightningRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private net.minecraft.world.level.block.state.BlockState state;
    private Map<Property<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends Block>, Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>> MAP = new HashMap<Class<? extends Block>, Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(net.minecraft.world.level.block.state.BlockState state) {
        this.state = state;
    }

    public Material getMaterial() {
        return CraftBlockType.minecraftToBukkit(this.state.getBlock());
    }

    public net.minecraft.world.level.block.state.BlockState getState() {
        return this.state;
    }

    protected <N extends Enum<N>, B extends Enum<B>> B get(CraftBlockStateEnum<N, B> nms) {
        return nms.toBukkit((Enum)this.state.getValue(nms.nms()));
    }

    protected <N extends Enum<N>, B extends Enum<B>> Set<B> getValues(CraftBlockStateEnum<N, B> nms) {
        return nms.getValues();
    }

    protected <N extends Enum<N>, B extends Enum<B>> void set(CraftBlockStateEnum<N, B> nms, B bukkit) {
        this.parsedStates = null;
        this.state = (net.minecraft.world.level.block.state.BlockState)this.state.setValue(nms.nms(), nms.toNMS(bukkit));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.getBlock() == craft.state.getBlock() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (Property<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (net.minecraft.world.level.block.state.BlockState)clone.state.setValue(parsed, craft.state.getValue(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.getBlock() != craft.state.getBlock()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals((Object)this);
        }
        return exactMatch;
    }

    protected <T extends Comparable<T>> T get(Property<T> ibs) {
        return this.state.getValue(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(Property<T> ibs, V v) {
        this.parsedStates = null;
        this.state = (net.minecraft.world.level.block.state.BlockState)this.state.setValue(ibs, v);
    }

    public String getAsString() {
        return this.toString(this.state.getValues());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<Property<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(BuiltInRegistries.BLOCK.getKey(this.state.getBlock()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(StateHolder.PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public Map<String, String> toStates(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? CraftBlockData.toStates(this.parsedStates) : CraftBlockData.toStates(this.state.getValues());
    }

    private static Map<String, String> toStates(Map<Property<?>, Comparable<?>> states) {
        HashMap<String, String> compound = new HashMap<String, String>();
        for (Map.Entry<Property<?>, Comparable<?>> entry : states.entrySet()) {
            Property<?> iblockstate = entry.getKey();
            compound.put(iblockstate.getName(), iblockstate.getName(entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static BooleanProperty getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(String name, Class<? extends Enum<B>> bukkit) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static IntegerProperty getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name) {
        return (BooleanProperty)CraftBlockData.getState(block, name, false);
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name, boolean optional) {
        return (BooleanProperty)CraftBlockData.getState(block, name, optional);
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(Class<? extends Block> block, String name, Class<B> bukkit) {
        return new CraftBlockStateEnum((EnumProperty)CraftBlockData.getState(block, name, false), bukkit);
    }

    protected static IntegerProperty getInteger(Class<? extends Block> block, String name) {
        return (IntegerProperty)CraftBlockData.getState(block, name, false);
    }

    private static Property<?> getState(Class<? extends Block> block, String name, boolean optional) {
        Property<?> state = null;
        for (Block instance : BuiltInRegistries.BLOCK) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.getStateDefinition().getProperty(name);
                continue;
            }
            Property<?> newState = instance.getStateDefinition().getProperty(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(IntegerProperty state) {
        return state.min;
    }

    protected static int getMax(IntegerProperty state) {
        return state.max;
    }

    private static void register(Class<? extends Block> nms, Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(BlockType blockType, String data) {
        net.minecraft.world.level.block.state.BlockState blockData;
        Block block = blockType == null ? null : (Block)((CraftBlockType)blockType).getHandle();
        Map<Property<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = String.valueOf(BuiltInRegistries.BLOCK.getKey(block)) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                BlockStateParser.BlockResult arg = BlockStateParser.parseForBlock(CraftRegistry.getMinecraftRegistry(Registries.BLOCK), reader, false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg.blockState();
                parsed = arg.properties();
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex);
            }
        } else {
            blockData = block.defaultBlockState();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(net.minecraft.world.level.block.state.BlockState data) {
        return (CraftBlockData)MAP.getOrDefault(data.getBlock().getClass(), (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.getSoundType());
    }

    public int getLightEmission() {
        return this.state.getLightEmission();
    }

    public boolean isOccluding() {
        return this.state.canOcclude();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.state.requiresCorrectToolForDrops();
    }

    public boolean isPreferredTool(ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(net.minecraft.world.level.block.state.BlockState iblockdata, net.minecraft.world.item.ItemStack nmsItem) {
        return !iblockdata.requiresCorrectToolForDrops() || nmsItem.isCorrectToolForDrops(iblockdata);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.state.getPistonPushReaction().ordinal());
    }

    public boolean isSupported(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.canSurvive(craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        BlockPos position = CraftLocation.toBlockPosition(location);
        return this.state.canSurvive(world.getHandle(), position);
    }

    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.isFaceSturdy(EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    public Color getMapColor() {
        return Color.fromRGB((int)this.state.getMapColor(null, null).col);
    }

    public Material getPlacementMaterial() {
        return CraftItemType.minecraftToBukkit(this.state.getBlock().asItem());
    }

    public void rotate(StructureRotation rotation) {
        this.state = this.state.rotate(Rotation.valueOf(rotation.name()));
    }

    public void mirror(org.bukkit.block.structure.Mirror mirror) {
        this.state = this.state.mirror(Mirror.valueOf(mirror.name()));
    }

    public void copyTo(BlockData blockData) {
        CraftBlockData other = (CraftBlockData)blockData;
        net.minecraft.world.level.block.state.BlockState nms = other.state;
        for (Property<?> property : this.state.getBlock().getStateDefinition().getProperties()) {
            if (!nms.hasProperty(property)) continue;
            nms = this.copyProperty(this.state, nms, property);
        }
        other.state = nms;
    }

    private <T extends Comparable<T>> net.minecraft.world.level.block.state.BlockState copyProperty(net.minecraft.world.level.block.state.BlockState source, net.minecraft.world.level.block.state.BlockState target, Property<T> property) {
        return (net.minecraft.world.level.block.state.BlockState)target.setValue(property, source.getValue(property));
    }

    @NotNull
    public BlockState createBlockState() {
        return CraftBlockStates.getBlockState(this.state, null);
    }

    static {
        CraftBlockData.register(AmethystClusterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(BigDripleafBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(BigDripleafStemBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(AnvilBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(BambooStalkBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(BannerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(WallBannerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(BarrelBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(BarrierBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBarrier::new));
        CraftBlockData.register(BedBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(BeehiveBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(BeetrootBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(BellBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(BlastFurnaceBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(BrewingStandBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(BubbleColumnBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(ButtonBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(CactusBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(CakeBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(CampfireBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(CarrotBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(ChainBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(ChestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(TrappedChestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(ChorusFlowerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(ChorusPlantBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(WallBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(CocoaBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(CommandBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(ComposterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(ConduitBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(BaseCoralPlantBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(CoralFanBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(BaseCoralFanBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(CoralWallFanBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(BaseCoralWallFanBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(CoralPlantBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(CropBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(DaylightDetectorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(SnowyDirtBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(DispenserBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(DoorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(DropperBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(EndRodBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(EnderChestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(EndPortalFrameBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(FenceBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(FenceGateBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(FireBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(StandingSignBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(LiquidBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(FurnaceBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(GlazedTerracottaBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(GrassBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(GrindstoneBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(HayBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(HopperBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(HugeMushroomBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(FrostedIceBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(IronBarsBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(JigsawBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(JukeboxBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(KelpBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(LadderBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(LanternBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(LecternBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(LeverBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(LoomBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(DetectorRailBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(RailBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(MyceliumBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(NetherWartBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(NoteBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(ObserverBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(NetherPortalBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(PotatoBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(PoweredRailBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(PressurePlateBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(WeightedPressurePlateBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(CarvedPumpkinBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(ComparatorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(RedstoneLampBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(RedStoneOreBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(RedstoneTorchBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(RedstoneWallTorchBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(RedStoneWireBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(SugarCaneBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(RepeaterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(RespawnAnchorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(RotatedPillarBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(SaplingBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(ScaffoldingBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(SeaPickleBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(ShulkerBoxBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(SkullBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(PlayerHeadBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(PlayerWallHeadBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(WallSkullBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(SmokerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(SnowLayerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(FarmBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(StainedGlassPaneBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(StairBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(StemBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(AttachedStemBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(SlabBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(StonecutterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(StructureBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(SweetBerryBushBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(TntBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(DoublePlantBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(TallFlowerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(TargetBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(WallTorchBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(TrapDoorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(TripWireBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(TripWireHookBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(TurtleEggBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(TwistingVinesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(VineBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(WallSignBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(WeepingVinesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(WitherSkullBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(WitherWallSkullBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(BrushableBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftBrushable::new));
        CraftBlockData.register(CalibratedSculkSensorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCalibratedSculkSensor::new));
        CraftBlockData.register(CandleBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(CandleCakeBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(CaveVinesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(CaveVinesPlantBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(CeilingHangingSignBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(ChiseledBookShelfBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(CopperBulbBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCopperBulb::new));
        CraftBlockData.register(CopperChestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCopperChest::new));
        CraftBlockData.register(CopperGolemStatueBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCopperGolemStatue::new));
        CraftBlockData.register(CrafterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCrafter::new));
        CraftBlockData.register(CreakingHeartBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftCreakingHeart::new));
        CraftBlockData.register(DecoratedPotBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(DriedGhastBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftDriedGhast::new));
        CraftBlockData.register(FlowerBedBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftFlowerBed::new));
        CraftBlockData.register(GlowLichenBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(HangingMossBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHangingMoss::new));
        CraftBlockData.register(HangingRootsBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(HeavyCoreBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftHeavyCore::new));
        CraftBlockData.register(InfestedRotatedPillarBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(LayeredCauldronBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(LeafLitterBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLeafLitter::new));
        CraftBlockData.register(LightBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(LightningRodBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(MangroveLeavesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(MangrovePropaguleBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(MangroveRootsBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(MossyCarpetBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMossyCarpet::new));
        CraftBlockData.register(MultifaceBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftMultiface::new));
        CraftBlockData.register(PiglinWallSkullBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(PitcherCropBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPitcherCrop::new));
        CraftBlockData.register(PointedDripstoneBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(SculkCatalystBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(SculkSensorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(SculkShriekerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(SculkVeinBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(ShelfBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftShelf::new));
        CraftBlockData.register(SmallDripleafBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(SnifferEggBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftSnifferEgg::new));
        CraftBlockData.register(TallSeagrassBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(TestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTest::new));
        CraftBlockData.register(TintedParticleLeavesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTintedParticleLeaves::new));
        CraftBlockData.register(TorchflowerCropBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(TrialSpawnerBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftTrialSpawner::new));
        CraftBlockData.register(UntintedParticleLeavesBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftUntintedParticleLeaves::new));
        CraftBlockData.register(VaultBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftVault::new));
        CraftBlockData.register(WallHangingSignBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(WaterloggedTransparentBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWaterloggedTransparent::new));
        CraftBlockData.register(WeatheringCopperBarsBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperBars::new));
        CraftBlockData.register(WeatheringCopperBulbBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperBulb::new));
        CraftBlockData.register(WeatheringCopperChainBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperChain::new));
        CraftBlockData.register(WeatheringCopperChestBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperChest::new));
        CraftBlockData.register(WeatheringCopperDoorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperDoor::new));
        CraftBlockData.register(WeatheringCopperGolemStatueBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperGolemStatue::new));
        CraftBlockData.register(WeatheringCopperGrateBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperGrate::new));
        CraftBlockData.register(WeatheringCopperSlabBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(WeatheringCopperStairBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(WeatheringCopperTrapDoorBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringCopperTrapDoor::new));
        CraftBlockData.register(WeatheringLanternBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringLantern::new));
        CraftBlockData.register(WeatheringLightningRodBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftWeatheringLightningRod::new));
        CraftBlockData.register(PistonBaseBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(PistonHeadBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(MovingPistonBlock.class, (Function<net.minecraft.world.level.block.state.BlockState, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

