/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftBlocksAttacksComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftCustomModelDataComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftWeaponComponent;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLegacy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB((int)10511680);
    private static final CraftItemFactory instance;
    private static final RandomSource randomSource;

    private CraftItemFactory() {
    }

    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"Meta of %s not created by %s", (Object)meta.getClass().toString(), (Object)CraftItemFactory.class.getName());
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    public ItemMeta getItemMeta(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        if (!(material = CraftLegacy.fromLegacy(material)).isItem()) {
            return new CraftMetaItem(meta);
        }
        return ((CraftItemType)material.asItemType()).getItemMeta(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta1 instanceof CraftMetaItem), (String)"First meta of %s does not belong to %s", (Object)meta1.getClass().getName(), (Object)CraftItemFactory.class.getName());
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta2 instanceof CraftMetaItem), (String)"Second meta of %s does not belong to %s", (Object)meta2.getClass().getName(), (Object)CraftItemFactory.class.getName());
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"ItemMeta of %s not created by %s", (Object)(meta != null ? meta.getClass().toString() : "null"), (Object)CraftItemFactory.class.getName());
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    public ItemStack createItemStack(String input) throws IllegalArgumentException {
        try {
            ItemParser.ItemResult arg = new ItemParser(MinecraftServer.getDefaultRegistryAccess()).parse(new StringReader(input));
            Item item = arg.item().value();
            net.minecraft.world.item.ItemStack nmsItemStack = new net.minecraft.world.item.ItemStack(item);
            DataComponentPatch nbt = arg.components();
            if (nbt != null) {
                nmsItemStack.applyComponents(nbt);
            }
            return CraftItemStack.asCraftMirror(nmsItemStack);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse ItemStack: " + input, ex);
        }
    }

    public Material getSpawnEgg(EntityType type) {
        if (type == EntityType.UNKNOWN) {
            return null;
        }
        net.minecraft.world.entity.EntityType<?> nmsType = CraftEntityType.bukkitToMinecraft(type);
        SpawnEggItem nmsItem = SpawnEggItem.byId(nmsType);
        if (nmsItem == null) {
            return null;
        }
        return CraftItemType.minecraftToBukkit(nmsItem);
    }

    public ItemStack enchantItem(Entity entity, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"The entity must not be null");
        return CraftItemFactory.enchantItem(((CraftEntity)entity).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(World world, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The world must not be null");
        return CraftItemFactory.enchantItem(((CraftWorld)world).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    private static ItemStack enchantItem(RandomSource source, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack must not be null");
        Preconditions.checkArgument((!itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"ItemStack must not be air");
        itemStack = CraftItemStack.asCraftCopy(itemStack);
        CraftItemStack craft = (CraftItemStack)itemStack;
        RegistryAccess registry = CraftRegistry.getMinecraftRegistry();
        Optional optional = allowTreasures ? Optional.empty() : registry.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        return CraftItemStack.asCraftMirror(EnchantmentHelper.enchantItem(source, craft.handle, level, registry, optional));
    }

    static {
        randomSource = RandomSource.create();
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(SerializableMeta.class);
        ConfigurationSerialization.registerClass(CraftCustomModelDataComponent.class);
        ConfigurationSerialization.registerClass(CraftBlocksAttacksComponent.class);
        ConfigurationSerialization.registerClass(CraftBlocksAttacksComponent.CraftDamageReduction.class);
        ConfigurationSerialization.registerClass(CraftEquippableComponent.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.CraftToolRule.class);
        ConfigurationSerialization.registerClass(CraftJukeboxComponent.class);
        ConfigurationSerialization.registerClass(CraftUseCooldownComponent.class);
        ConfigurationSerialization.registerClass(CraftWeaponComponent.class);
    }
}

