/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftOldEnumRegistryItem;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements Frog {
    public CraftFrog(CraftServer server, csv entity) {
        super(server, entity);
    }

    @Override
    public csv getHandle() {
        return (csv)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    public Entity getTongueTarget() {
        return this.getHandle().n().map(cdv::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().m();
        } else {
            this.getHandle().G(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().s());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends CraftOldEnumRegistryItem<Frog.Variant, csx>
    implements Frog.Variant {
        private static int count = 0;

        public static Frog.Variant minecraftToBukkit(csx minecraft) {
            return (Frog.Variant)CraftRegistry.minecraftToBukkit(minecraft, mp.bb, Registry.FROG_VARIANT);
        }

        public static Frog.Variant minecraftHolderToBukkit(jk<csx> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static csx bukkitToMinecraft(Frog.Variant bukkit) {
            return (csx)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jk<csx> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, mp.bb);
        }

        public CraftVariant(NamespacedKey key, jk<csx> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

