/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.help;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_21_R6.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_21_R6.help.CustomIndexHelpTopic;
import org.bukkit.craftbukkit.v1_21_R6.help.HelpTopicAmendment;
import org.bukkit.help.HelpTopic;

public class HelpYamlReader {
    private YamlConfiguration helpYaml;
    private final char ALT_COLOR_CODE = (char)38;
    private final Server server;

    public HelpYamlReader(Server server) {
        this.server = server;
        File helpYamlFile = new File("help.yml");
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/help.yml"), Charsets.UTF_8));
        try {
            this.helpYaml = YamlConfiguration.loadConfiguration((File)helpYamlFile);
            this.helpYaml.options().copyDefaults(true);
            this.helpYaml.setDefaults((Configuration)defaultConfig);
            try {
                if (!helpYamlFile.exists()) {
                    this.helpYaml.save(helpYamlFile);
                }
            }
            catch (IOException ex2) {
                server.getLogger().log(Level.SEVERE, "Could not save " + String.valueOf(helpYamlFile), ex2);
            }
        }
        catch (Exception ex3) {
            server.getLogger().severe("Failed to load help.yml. Verify the yaml indentation is correct. Reverting to default help.yml.");
            this.helpYaml = defaultConfig;
        }
    }

    public List<HelpTopic> getGeneralTopics() {
        LinkedList<HelpTopic> topics = new LinkedList<HelpTopic>();
        ConfigurationSection generalTopics = this.helpYaml.getConfigurationSection("general-topics");
        if (generalTopics != null) {
            for (String topicName : generalTopics.getKeys(false)) {
                ConfigurationSection section = generalTopics.getConfigurationSection(topicName);
                String shortText = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("shortText", ""));
                String fullText = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("fullText", ""));
                String permission = section.getString("permission", "");
                topics.add(new CustomHelpTopic(topicName, shortText, fullText, permission));
            }
        }
        return topics;
    }

    public List<HelpTopic> getIndexTopics() {
        LinkedList<HelpTopic> topics = new LinkedList<HelpTopic>();
        ConfigurationSection indexTopics = this.helpYaml.getConfigurationSection("index-topics");
        if (indexTopics != null) {
            for (String topicName : indexTopics.getKeys(false)) {
                ConfigurationSection section = indexTopics.getConfigurationSection(topicName);
                String shortText = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("shortText", ""));
                String preamble = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("preamble", ""));
                String permission = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("permission", ""));
                List commands = section.getStringList("commands");
                topics.add((HelpTopic)new CustomIndexHelpTopic(this.server.getHelpMap(), topicName, shortText, permission, commands, preamble));
            }
        }
        return topics;
    }

    public List<HelpTopicAmendment> getTopicAmendments() {
        LinkedList<HelpTopicAmendment> amendments = new LinkedList<HelpTopicAmendment>();
        ConfigurationSection commandTopics = this.helpYaml.getConfigurationSection("amended-topics");
        if (commandTopics != null) {
            for (String topicName : commandTopics.getKeys(false)) {
                ConfigurationSection section = commandTopics.getConfigurationSection(topicName);
                String description = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("shortText", ""));
                String usage = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("fullText", ""));
                String permission = section.getString("permission", "");
                amendments.add(new HelpTopicAmendment(topicName, description, usage, permission));
            }
        }
        return amendments;
    }

    public List<String> getIgnoredPlugins() {
        return this.helpYaml.getStringList("ignore-plugins");
    }

    public boolean commandTopicsInMasterIndex() {
        return this.helpYaml.getBoolean("command-topics-in-master-index", true);
    }
}

