/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        cef nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        cef nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(cef.a);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(cef.a, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(cef.b);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(cef.b, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(cef.f);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(cef.f, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(cef.e);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(cef.e, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(cef.d);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(cef.d, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(cef.c);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(cef.c, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(cef.c), this.getEquipment(cef.d), this.getEquipment(cef.e), this.getEquipment(cef.f)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(cef.c, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(cef.d, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(cef.e, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(cef.f, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(cef slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().a(slot));
    }

    private void setEquipment(cef slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    public void clear() {
        for (cef slot : cef.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(cef.a);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(cef.a, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(cef.b);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(cef.b, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(cef.f);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(cef.f, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(cef.e);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(cef.e, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(cef.d);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(cef.d, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(cef.c);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(cef.c, chance);
    }

    private void setDropChance(cef slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof cey), (Object)"Cannot set drop chance for non-Mob entity");
        ((cey)this.entity.getHandle()).a(slot, chance);
    }

    private float getDropChance(cef slot) {
        if (!(this.entity.getHandle() instanceof cey)) {
            return 1.0f;
        }
        return ((cey)this.entity.getHandle()).gp().b(slot);
    }
}

