/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new HashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, un.class, (byte)1, un::a, un::j);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, vi.class, (byte)2, vi::a, vi::i);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, uu.class, (byte)3, uu::a, uu::h);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, ux.class, (byte)4, ux::a, ux::g);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, us.class, (byte)5, us::a, us::l);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, uq.class, (byte)6, uq::a, uq::k);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, vn.class, (byte)8, vn::a, vn::k);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, um.class, (byte)7, array -> new um(Arrays.copyOf(array, ((byte[])array).length)), n2 -> Arrays.copyOf(n2.e(), n2.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, ut.class, (byte)11, array -> new ut(Arrays.copyOf(array, ((int[])array).length)), n2 -> Arrays.copyOf(n2.g(), n2.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, uw.class, (byte)12, array -> new uw(Arrays.copyOf(array, ((long[])array).length)), n2 -> Arrays.copyOf(n2.g(), n2.size()));
        }
        if (Objects.equals(PersistentDataContainer[].class, type)) {
            return this.createAdapter(PersistentDataContainer[].class, uv.class, (byte)9, containerArray -> {
                uv list = new uv();
                for (PersistentDataContainer persistentDataContainer : containerArray) {
                    list.add(((CraftPersistentDataContainer)persistentDataContainer).toTagCompound());
                }
                return list;
            }, tag -> {
                PersistentDataContainer[] containerArray = new CraftPersistentDataContainer[tag.size()];
                for (int i2 = 0; i2 < tag.size(); ++i2) {
                    CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                    up compound = tag.b(i2);
                    for (String key : compound.e()) {
                        container.put(key, compound.a(key));
                    }
                    containerArray[i2] = container;
                }
                return containerArray;
            });
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, up.class, (byte)10, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.e()) {
                    container.put(key, tag.a(key));
                }
                return container;
            });
        }
        if (Objects.equals(List.class, type)) {
            return this.createAdapter(List.class, uv.class, (byte)9, this::constructList, this::extractList, this::matchesListTag);
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends vp> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, byte nmsTypeByte, Function<T, Z> builder, Function<Z, T> extractor) {
        return this.createAdapter(primitiveType, nbtBaseType, nmsTypeByte, (type, t2) -> (vp)builder.apply(t2), (type, z2) -> extractor.apply(z2), (type, t2) -> nbtBaseType.isInstance(t2));
    }

    private <T, Z extends vp> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, byte nmsTypeByte, BiFunction<PersistentDataType<T, ?>, T, Z> builder, BiFunction<PersistentDataType<T, ?>, Z, T> extractor, BiPredicate<PersistentDataType<T, ?>, vp> matcher) {
        return new TagAdapter<T, Z>(primitiveType, nbtBaseType, nmsTypeByte, builder, extractor, matcher);
    }

    public <T> vp wrap(PersistentDataType<T, ?> type, T value) {
        return this.getOrCreateAdapter(type).build(type, value);
    }

    public <T> boolean isInstanceOf(PersistentDataType<T, ?> type, vp base) {
        return this.getOrCreateAdapter(type).isInstance(type, base);
    }

    @NotNull
    private <T, Z extends vp> TagAdapter<T, Z> getOrCreateAdapter(@NotNull PersistentDataType<T, ?> type) {
        return this.adapters.computeIfAbsent(type.getPrimitiveType(), this.CREATE_ADAPTER);
    }

    public <T, Z extends vp> T extract(PersistentDataType<T, ?> type, vp tag) throws ClassCastException, IllegalArgumentException {
        Class primitiveType = type.getPrimitiveType();
        TagAdapter<T, Z> adapter = this.getOrCreateAdapter(type);
        Preconditions.checkArgument((boolean)adapter.isInstance(type, tag), (String)"The found tag instance (%s) cannot store %s", (Object)tag.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        T foundValue = adapter.extract(type, tag);
        Preconditions.checkArgument((boolean)primitiveType.isInstance(foundValue), (String)"The found object is of the type %s. Expected type %s", (Object)foundValue.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        return primitiveType.cast(foundValue);
    }

    private <P, T extends List<P>> uv constructList(@NotNull PersistentDataType<T, ?> type, @NotNull List<P> list) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The passed list cannot be written to the PDC with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        ArrayList values = Lists.newArrayListWithCapacity((int)list.size());
        for (P primitiveValue : list) {
            values.add(this.wrap(listPersistentDataType.elementType(), primitiveValue));
        }
        return new uv(values);
    }

    private <P> List<P> extractList(@NotNull PersistentDataType<P, ?> type, @NotNull uv listTag) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The found list tag cannot be read with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        ObjectArrayList output = new ObjectArrayList(listTag.size());
        for (vp tag : listTag) {
            output.add(this.extract(listPersistentDataType.elementType(), tag));
        }
        return output;
    }

    private boolean matchesListTag(PersistentDataType<List, ?> type, vp tag) {
        if (!(type instanceof ListPersistentDataType)) {
            return false;
        }
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        if (!(tag instanceof uv)) {
            return false;
        }
        uv listTag = (uv)tag;
        byte elementType = listTag.e();
        TagAdapter elementAdapter = this.getOrCreateAdapter(listPersistentDataType.elementType());
        return elementAdapter.nmsTypeByte() == elementType || elementType == 0;
    }

    private record TagAdapter<P, T extends vp>(Class<P> primitiveType, Class<T> nbtBaseType, byte nmsTypeByte, BiFunction<PersistentDataType<P, ?>, P, T> builder, BiFunction<PersistentDataType<P, ?>, T, P> extractor, BiPredicate<PersistentDataType<P, ?>, vp> matcher) {
        private P extract(PersistentDataType<P, ?> dataType, vp base) {
            Preconditions.checkArgument((boolean)this.nbtBaseType.isInstance(base), (String)"The provided NBTBase was of the type %s. Expected type %s", (Object)base.getClass().getSimpleName(), (Object)this.nbtBaseType.getSimpleName());
            return this.extractor.apply(dataType, (PersistentDataType<P, ?>)((vp)this.nbtBaseType.cast(base)));
        }

        private T build(PersistentDataType<P, ?> dataType, Object value) {
            Preconditions.checkArgument((boolean)this.primitiveType.isInstance(value), (String)"The provided value was of the type %s. Expected type %s", (Object)value.getClass().getSimpleName(), (Object)this.primitiveType.getSimpleName());
            return (T)((vp)this.builder.apply(dataType, this.primitiveType.cast(value)));
        }

        private boolean isInstance(PersistentDataType<P, ?> persistentDataType, vp base) {
            return this.matcher.test(persistentDataType, base);
        }
    }
}

