/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_21_R6.CraftCrashReport;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger a = LogUtils.getLogger();
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String c;
    private final Throwable d;
    private final List<CrashReportSystemDetails> e = Lists.newArrayList();
    @Nullable
    private Path f;
    private boolean g = true;
    private StackTraceElement[] h = new StackTraceElement[0];
    private final SystemReport i = new SystemReport();

    public CrashReport(String s2, Throwable throwable) {
        this.c = s2;
        this.d = throwable;
        this.i.a("CraftBukkit Information", new CraftCrashReport());
    }

    public String a() {
        return this.c;
    }

    public Throwable b() {
        return this.d;
    }

    public String c() {
        StringBuilder stringbuilder = new StringBuilder();
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    public void a(StringBuilder stringbuilder) {
        if (!(this.h != null && this.h.length > 0 || this.e.isEmpty())) {
            this.h = (StackTraceElement[])ArrayUtils.subarray((Object[])this.e.get(0).a(), (int)0, (int)1);
        }
        if (this.h != null && this.h.length > 0) {
            stringbuilder.append("-- Head --\n");
            stringbuilder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            stringbuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.h) {
                stringbuilder.append("\t").append("at ").append(stacktraceelement);
                stringbuilder.append("\n");
            }
            stringbuilder.append("\n");
        }
        for (CrashReportSystemDetails crashreportsystemdetails : this.e) {
            crashreportsystemdetails.a(stringbuilder);
            stringbuilder.append("\n\n");
        }
        this.i.a(stringbuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String d() {
        String s2;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable throwable = this.d;
        if (throwable.getMessage() == null) {
            if (throwable instanceof NullPointerException) {
                throwable = new NullPointerException(this.c);
            } else if (throwable instanceof StackOverflowError) {
                throwable = new StackOverflowError(this.c);
            } else if (throwable instanceof OutOfMemoryError) {
                throwable = new OutOfMemoryError(this.c);
            }
            throwable.setStackTrace(this.d.getStackTrace());
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            throwable.printStackTrace(printwriter);
            s2 = stringwriter.toString();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable2;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s2;
    }

    public String a(ReportType reporttype, List<String> list) {
        StringBuilder stringbuilder = new StringBuilder();
        reporttype.a(stringbuilder, list);
        stringbuilder.append("Time: ");
        stringbuilder.append(b.format(ZonedDateTime.now()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.c);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.d());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    public String a(ReportType reporttype) {
        return this.a(reporttype, List.of());
    }

    @Nullable
    public Path e() {
        return this.f;
    }

    public boolean a(Path path, ReportType reporttype, List<String> list) {
        if (this.f != null) {
            return false;
        }
        try {
            if (path.getParent() != null) {
                FileUtils.c(path.getParent());
            }
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(this.a(reporttype, list));
            }
            this.f = path;
            return true;
        }
        catch (Throwable throwable) {
            a.error("Could not save crash report to {}", (Object)path, (Object)throwable);
            return false;
        }
    }

    public boolean a(Path path, ReportType reporttype) {
        return this.a(path, reporttype, List.of());
    }

    public SystemReport f() {
        return this.i;
    }

    public CrashReportSystemDetails a(String s2) {
        return this.a(s2, 1);
    }

    public CrashReportSystemDetails a(String s2, int i2) {
        CrashReportSystemDetails crashreportsystemdetails = new CrashReportSystemDetails(s2);
        if (this.g) {
            int j2 = crashreportsystemdetails.a(i2);
            StackTraceElement[] astacktraceelement = this.d.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int k2 = astacktraceelement.length - j2;
            if (k2 < 0) {
                a.error("Negative index in crash report handler ({}/{})", (Object)astacktraceelement.length, (Object)j2);
            }
            if (astacktraceelement != null && 0 <= k2 && k2 < astacktraceelement.length) {
                stacktraceelement = astacktraceelement[k2];
                if (astacktraceelement.length + 1 - j2 < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j2];
                }
            }
            this.g = crashreportsystemdetails.a(stacktraceelement, stacktraceelement1);
            if (astacktraceelement != null && astacktraceelement.length >= j2 && 0 <= k2 && k2 < astacktraceelement.length) {
                this.h = new StackTraceElement[k2];
                System.arraycopy(astacktraceelement, 0, this.h, 0, this.h.length);
            } else {
                this.g = false;
            }
        }
        this.e.add(crashreportsystemdetails);
        return crashreportsystemdetails;
    }

    public static CrashReport a(Throwable throwable, String s2) {
        CrashReport crashreport;
        while (throwable instanceof CompletionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable;
            crashreport = reportedexception.a();
        } else {
            crashreport = new CrashReport(s2, throwable);
        }
        return crashreport;
    }

    public static void g() {
        MemoryReserve.a();
        new CrashReport("Don't panic!", new Throwable()).a(ReportType.a);
    }
}

