/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.scores.ScoreAccess;

public class ArgumentMathOperation
implements ArgumentType<a> {
    private static final Collection<String> a = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.div0"));

    public static ArgumentMathOperation a() {
        return new ArgumentMathOperation();
    }

    public static a a(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (a)var0.getArgument(var1, a.class);
    }

    public a a(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead()) {
            int var1 = var0.getCursor();
            while (var0.canRead() && var0.peek() != ' ') {
                var0.skip();
            }
            return ArgumentMathOperation.a(var0.getString().substring(var1, var0.getCursor()));
        }
        throw b.createWithContext((ImmutableStringReader)var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.a(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, var1);
    }

    public Collection<String> getExamples() {
        return a;
    }

    private static a a(String var02) throws CommandSyntaxException {
        if (var02.equals("><")) {
            return (var0, var1) -> {
                int var2 = var0.a();
                var0.a(var1.a());
                var1.a(var2);
            };
        }
        return ArgumentMathOperation.b(var02);
    }

    private static b b(String var02) throws CommandSyntaxException {
        return switch (var02) {
            case "=" -> (var0, var1) -> var1;
            case "+=" -> Integer::sum;
            case "-=" -> (var0, var1) -> var0 - var1;
            case "*=" -> (var0, var1) -> var0 * var1;
            case "/=" -> (var0, var1) -> {
                if (var1 == 0) {
                    throw c.create();
                }
                return MathHelper.a(var0, var1);
            };
            case "%=" -> (var0, var1) -> {
                if (var1 == 0) {
                    throw c.create();
                }
                return MathHelper.b(var0, var1);
            };
            case "<" -> Math::min;
            case ">" -> Math::max;
            default -> throw b.create();
        };
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    @FunctionalInterface
    public static interface a {
        public void apply(ScoreAccess var1, ScoreAccess var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b
    extends a {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(ScoreAccess var0, ScoreAccess var1) throws CommandSyntaxException {
            var0.a(this.apply(var0.a(), var1.a()));
        }
    }
}

