/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagIntArray
implements NBTList {
    private static final int b = 24;
    public static final NBTTagType<NBTTagIntArray> a = new NBTTagType.b<NBTTagIntArray>(){

        public NBTTagIntArray a(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            return new NBTTagIntArray(1.d(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
            return streamtagvisitor.a(1.d(datainput, nbtreadlimiter));
        }

        private static int[] d(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            nbtreadlimiter.b(24L);
            int i2 = datainput.readInt();
            Preconditions.checkArgument((i2 < 0x1000000 ? 1 : 0) != 0);
            nbtreadlimiter.a(4L, i2);
            int[] aint = new int[i2];
            for (int j2 = 0; j2 < i2; ++j2) {
                aint[j2] = datainput.readInt();
            }
            return aint;
        }

        @Override
        public void b(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 4);
        }

        @Override
        public String a() {
            return "INT[]";
        }

        @Override
        public String b() {
            return "TAG_Int_Array";
        }
    };
    private int[] c;

    public NBTTagIntArray(int[] aint) {
        this.c = aint;
    }

    @Override
    public void a(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.c.length);
        for (int i2 : this.c) {
            dataoutput.writeInt(i2);
        }
    }

    @Override
    public int a() {
        return 24 + 4 * this.c.length;
    }

    @Override
    public byte b() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringtagvisitor = new StringTagVisitor();
        stringtagvisitor.a(this);
        return stringtagvisitor.a();
    }

    public NBTTagIntArray e() {
        int[] aint = new int[this.c.length];
        System.arraycopy(this.c, 0, aint, 0, this.c.length);
        return new NBTTagIntArray(aint);
    }

    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagIntArray && Arrays.equals(this.c, ((NBTTagIntArray)object).c);
    }

    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    public int[] g() {
        return this.c;
    }

    @Override
    public void a(TagVisitor tagvisitor) {
        tagvisitor.a(this);
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagInt a(int i2) {
        return NBTTagInt.a(this.c[i2]);
    }

    @Override
    public boolean a(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            NBTNumber nbtnumber = (NBTNumber)nbtbase;
            this.c[i2] = nbtnumber.h();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            NBTNumber nbtnumber = (NBTNumber)nbtbase;
            this.c = ArrayUtils.add((int[])this.c, (int)i2, (int)nbtnumber.h());
            return true;
        }
        return false;
    }

    public NBTTagInt b(int i2) {
        int j2 = this.c[i2];
        this.c = ArrayUtils.remove((int[])this.c, (int)i2);
        return NBTTagInt.a(j2);
    }

    @Override
    public void clear() {
        this.c = new int[0];
    }

    @Override
    public Optional<int[]> s_() {
        return Optional.of(this.c);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.a(this.c);
    }
}

