/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer a;
    private final JsonRpcLogger b;

    public MinecraftGameRuleServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.a = var0;
        this.b = var1;
    }

    @Override
    public GameRulesService.b a(GameRulesService.c var0, ClientInfo var1) {
        Object var5;
        GameRules.GameRuleValue<?> var2 = this.b(var0.a());
        String var3 = var2.b();
        if (var2 instanceof GameRules.GameRuleBoolean) {
            var5 = (GameRules.GameRuleBoolean)var2;
            var5.a(Boolean.parseBoolean(var0.b()), (MinecraftServer)this.a);
        } else if (var2 instanceof GameRules.GameRuleInt) {
            GameRules.GameRuleInt var4 = (GameRules.GameRuleInt)var2;
            var4.a(Integer.parseInt(var0.b()), this.a);
        } else {
            throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + var0.a());
        }
        var5 = this.a(var0.a(), var2);
        this.b.a(var1, "Game rule '{}' updated from '{}' to '{}'", ((GameRulesService.b)var5).a(), var3, ((GameRulesService.b)var5).b());
        this.a.a(var0.a(), var2);
        return var5;
    }

    @Override
    public <T extends GameRules.GameRuleValue<T>> T a(GameRules.GameRuleKey<T> var0) {
        return this.a.aQ().b(var0);
    }

    @Override
    public GameRulesService.b a(String var0, GameRules.GameRuleValue<?> var1) {
        GameRules.GameRuleValue<?> gameRuleValue = var1;
        Objects.requireNonNull(gameRuleValue);
        GameRules.GameRuleValue<?> gameRuleValue2 = gameRuleValue;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.GameRuleBoolean.class, GameRules.GameRuleInt.class}, gameRuleValue2, n2)) {
            case 0 -> {
                GameRules.GameRuleBoolean var4 = (GameRules.GameRuleBoolean)gameRuleValue2;
                yield new GameRulesService.b(var0, String.valueOf(var4.a()), GameRulesService.a.b);
            }
            case 1 -> {
                GameRules.GameRuleInt var5 = (GameRules.GameRuleInt)gameRuleValue2;
                yield new GameRulesService.b(var0, String.valueOf(var5.a()), GameRulesService.a.a);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> a() {
        FeatureFlagSet var0 = this.a.bf().I().g().b();
        return GameRules.a(var0);
    }

    private Optional<GameRules.GameRuleKey<?>> a(String var0) {
        Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> var12 = this.a();
        return var12.filter(var1 -> ((GameRules.GameRuleKey)var1.getKey()).a().equals(var0)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.GameRuleValue<?> b(String var0) {
        GameRules.GameRuleKey<?> var1 = this.a(var0).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + var0 + "' does not exist"));
        return this.a.aQ().b(var1);
    }
}

