/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger b = LogUtils.getLogger();
    private int c;
    protected BlockPosition a;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> entitytypes, World world) {
        super(entitytypes, world);
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> entitytypes, World world, BlockPosition blockposition) {
        this(entitytypes, world);
        this.a = blockposition;
    }

    protected abstract void e();

    @Override
    public void g() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.aI();
            if (this.c++ == this.an().spigotConfig.hangingTickFrequency) {
                this.c = 0;
                if (!this.ec() && !this.f()) {
                    IBlockData material = this.an().a_(this.dF());
                    HangingBreakEvent.RemoveCause cause = !material.l() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.ec() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.a(worldserver, (Entity)null);
                }
            }
        }
    }

    public abstract boolean f();

    @Override
    public boolean bT() {
        return true;
    }

    @Override
    public boolean w(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return !this.an().a((Entity)entityhuman, this.a) ? true : this.b(this.ei().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return !this.d(damagesource);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.d(damagesource)) {
            return false;
        }
        if (!worldserver.S().c(GameRules.d) && damagesource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.ec()) {
            Entity damager;
            Entity entity = damager = damagesource.b() ? damagesource.c() : damagesource.d();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.ec() || event.isCancelled()) {
                return true;
            }
            this.c(worldserver);
            this.bP();
            this.a(worldserver, damagesource.d());
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        Entity entity = explosion.d();
        return entity != null && entity.bu() ? true : (explosion.h() ? super.a(explosion) : true);
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.ec() && vec3d.h() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.ec() || event.isCancelled()) {
                    return;
                }
                this.c(worldserver);
                this.a(worldserver, (Entity)null);
            }
        }
    }

    @Override
    public void i(double d0, double d1, double d2) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput, boolean includeAll) {
        if (includeAll) {
            this.a(valueoutput);
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a("block_pos", BlockPosition.a, this.i());
    }

    @Override
    protected void a(ValueInput valueinput) {
        BlockPosition blockposition = valueinput.a("block_pos", BlockPosition.a).orElse(null);
        if (blockposition != null && blockposition.a(this.dF(), 16.0)) {
            this.a = blockposition;
        } else {
            b.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        }
    }

    public abstract void a(WorldServer var1, @Nullable Entity var2);

    @Override
    protected boolean bV() {
        return false;
    }

    @Override
    public void a_(double d0, double d1, double d2) {
        this.a = BlockPosition.a(d0, d1, d2);
        this.e();
        this.aF = true;
    }

    public BlockPosition i() {
        return this.a;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
    }

    @Override
    public void l_() {
    }
}

