/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> f = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int ct = 3600;
    private static final int cu = 6000;
    private static final int cv = 14;
    private static final int cw = 4;
    private static final int cx = -1;
    private static final int cy = 0;
    public int cz;
    @Nullable
    public UUID cA;
    @Nullable
    private Reputation cB;
    @Nullable
    private MerchantRecipeList cC;
    private int cD = 0;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entitytypes, World world) {
        super((EntityTypes<? extends EntityZombie>)entitytypes, world);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, false);
        datawatcher_a.a(f, this.gT());
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("VillagerData", VillagerData.c, this.gR());
        valueoutput.b("Offers", MerchantRecipeList.a, this.cC);
        valueoutput.b("Gossips", Reputation.a, this.cB);
        valueoutput.a("ConversionTime", this.gQ() ? this.cz : -1);
        valueoutput.b("ConversionPlayer", UUIDUtil.a, this.cA);
        valueoutput.a("Xp", this.cD);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.az.a(f, valueinput.a("VillagerData", VillagerData.c).orElseGet(this::gT));
        this.cC = valueinput.a("Offers", MerchantRecipeList.a).orElse(null);
        this.cB = valueinput.a("Gossips", Reputation.a).orElse(null);
        int i2 = valueinput.a("ConversionTime", -1);
        if (i2 != -1) {
            UUID uuid = valueinput.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, i2);
        } else {
            this.aC().a(a, false);
            this.cz = -1;
        }
        this.cD = valueinput.a("Xp", 0);
    }

    private VillagerData gT() {
        World world = this.an();
        Optional optional = BuiltInRegistries.y.a(this.as);
        VillagerData villagerdata = EntityVillager.gX().a(world.L_(), VillagerType.a(world.v(this.dF())));
        if (optional.isPresent()) {
            villagerdata = villagerdata.b(optional.get());
        }
        return villagerdata;
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && this.gQ()) {
            int i2 = this.gU();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cz -= (i2 *= elapsedTicks);
            if (this.cz <= 0) {
                this.h((WorldServer)this.an());
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.rK)) {
            if (this.d(MobEffects.r)) {
                itemstack.a(1, (EntityLiving)entityhuman);
                if (!this.an().D_()) {
                    this.b(entityhuman.cT(), this.as.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    protected boolean gI() {
        return false;
    }

    @Override
    public boolean i(double d0) {
        return !this.gQ() && this.cD == 0;
    }

    public boolean gQ() {
        return this.aC().a(a);
    }

    public void b(@Nullable UUID uuid, int i2) {
        this.cA = uuid;
        this.cz = i2;
        this.aC().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, i2, Math.min(this.an().aq().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.an().a((Entity)this, (byte)16);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 16) {
            if (!this.bm()) {
                this.an().a(this.dK(), this.dO(), this.dQ(), SoundEffects.Ga, this.dw(), 1.0f + this.as.i(), this.as.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(b0);
        }
    }

    private void h(WorldServer worldserver) {
        EntityVillager converted = this.convertTo(EntityTypes.bI, ConversionParams.a(this, false, false), entityvillager -> {
            EntityHuman entityhuman;
            this.forceDrops = false;
            for (EnumItemSlot enumitemslot : this.a(worldserver, (ItemStack itemstack) -> !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E))) {
                SlotAccess slotaccess = entityvillager.a_(enumitemslot.b() + 300);
                slotaccess.a(this.a(enumitemslot));
            }
            entityvillager.a(this.gR());
            if (this.cB != null) {
                entityvillager.a(this.cB);
            }
            if (this.cC != null) {
                entityvillager.b(this.cC.a());
            }
            entityvillager.t(this.cD);
            entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.dF()), EntitySpawnReason.i, (GroupDataEntity)null);
            entityvillager.h(worldserver);
            if (this.cA != null && (entityhuman = worldserver.c(this.cA)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)entityhuman, this, (EntityVillager)entityvillager);
                worldserver.a(ReputationEvent.a, (Entity)entityhuman, (ReputationHandler)((Object)entityvillager));
            }
            entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bm()) {
                worldserver.a((Entity)null, 1027, this.dF(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int i2) {
        this.cz = i2;
    }

    private int gU() {
        int i2 = 1;
        if (this.as.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dK() - 4; k2 < (int)this.dK() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dM() - 4; l2 < (int)this.dM() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dQ() - 4; i1 < (int)this.dQ() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.an().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.fC) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.as.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fu() {
        return this.g_() ? (this.as.i() - this.as.i()) * 0.2f + 2.0f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.FY;
    }

    @Override
    public SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Gc;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Gb;
    }

    @Override
    public SoundEffect n() {
        return SoundEffects.Gd;
    }

    public void a(MerchantRecipeList merchantrecipelist) {
        this.cC = merchantrecipelist;
    }

    public void a(Reputation reputation) {
        this.cB = reputation;
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gR();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.cC = null;
        }
        this.az.a(f, villagerdata);
    }

    @Override
    public VillagerData gR() {
        return this.az.a(f);
    }

    public int gS() {
        return this.cD;
    }

    public void s(int i2) {
        this.cD = i2;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.av ? EntityZombieVillager.c(datacomponenttype, this.gR().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.av);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.av) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.av, t0);
            this.a(this.gR().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

