/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;

public class RecipeMap {
    public static final RecipeMap a = new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Maps.newLinkedHashMap());
    public final Multimap<Recipes<?>, RecipeHolder<?>> b;
    private final LinkedHashMap<ResourceKey<IRecipe<?>>, RecipeHolder<?>> c;

    private RecipeMap(Multimap<Recipes<?>, RecipeHolder<?>> multimap, LinkedHashMap<ResourceKey<IRecipe<?>>, RecipeHolder<?>> map) {
        this.b = multimap;
        this.c = map;
    }

    public static RecipeMap a(Iterable<RecipeHolder<?>> iterable) {
        ImmutableMultimap.Builder immutablemultimap_builder = ImmutableMultimap.builder();
        ImmutableMap.Builder immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : iterable) {
            immutablemultimap_builder.put(recipeholder.b().b(), recipeholder);
            immutablemap_builder.put(recipeholder.a(), recipeholder);
        }
        return new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)LinkedHashMultimap.create((Multimap)immutablemultimap_builder.build()), Maps.newLinkedHashMap((Map)immutablemap_builder.build()));
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        Collection map = this.b.get(irecipe.b().b());
        if (this.c.containsKey(irecipe.a())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.a()));
        }
        map.add(irecipe);
        this.c.putFirst(irecipe.a(), irecipe);
    }

    public boolean removeRecipe(ResourceKey<IRecipe<?>> mcKey) {
        boolean removed = false;
        Iterator iter = this.b.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.a().equals(mcKey)) continue;
            iter.remove();
            removed = true;
        }
        return removed |= this.c.remove(mcKey) != null;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> a(Recipes<T> recipes) {
        return this.b.get(recipes);
    }

    public Collection<RecipeHolder<?>> a() {
        return this.c.values();
    }

    @Nullable
    public RecipeHolder<?> a(ResourceKey<IRecipe<?>> resourcekey) {
        return this.c.get(resourcekey);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Stream<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world) {
        return i0.b() ? Stream.empty() : this.a(recipes).stream().filter(recipeholder -> recipeholder.b().a((RecipeInput)i0, world));
    }
}

