/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.OptionalDynamic;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private WorldData.a k;
    private long l;
    private long m;
    @Nullable
    private final NBTTagCompound n;
    private final int o;
    private int p;
    private boolean q;
    private int r;
    private boolean s;
    private int t;
    private boolean u;
    private boolean v;
    @Deprecated
    private Optional<WorldBorder.c> w;
    private EnderDragonBattle.a x;
    @Nullable
    private NBTTagCompound y;
    private int z;
    private int A;
    @Nullable
    private UUID B;
    private final Set<String> C;
    private boolean D;
    private final Set<String> E;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> F;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound nbttagcompound, boolean flag, WorldData.a worlddata_a, long i2, long j2, int k2, int l2, int i1, boolean flag1, int j1, boolean flag2, boolean flag3, boolean flag4, Optional<WorldBorder.c> optional, int k1, int l1, @Nullable UUID uuid, Set<String> set, Set<String> set1, CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue, @Nullable NBTTagCompound nbttagcompound1, EnderDragonBattle.a enderdragonbattle_a, WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this.D = flag;
        this.k = worlddata_a;
        this.l = i2;
        this.m = j2;
        this.o = k2;
        this.p = l2;
        this.r = i1;
        this.q = flag1;
        this.t = j1;
        this.s = flag2;
        this.u = flag3;
        this.v = flag4;
        this.w = optional;
        this.z = k1;
        this.A = l1;
        this.B = uuid;
        this.C = set;
        this.E = set1;
        this.n = nbttagcompound;
        this.F = customfunctioncallbacktimerqueue;
        this.y = nbttagcompound1;
        this.x = enderdragonbattle_a;
        this.g = worldsettings;
        this.h = worldoptions;
        this.i = worlddataserver_a;
        this.j = lifecycle;
    }

    public WorldDataServer(WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this(null, false, WorldData.a.a, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, Optional.empty(), 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, worldsettings.h(), worldoptions, worlddataserver_a, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, WorldSettings worldsettings, a worlddataserver_a, WorldOptions worldoptions, Lifecycle lifecycle) {
        long i2 = dynamic.get("Time").asLong(0L);
        OptionalDynamic optionaldynamic = dynamic.get(b);
        Codec<NBTTagCompound> codec = NBTTagCompound.a;
        Objects.requireNonNull(codec);
        NBTTagCompound nbttagcompound = optionaldynamic.flatMap(arg_0 -> codec.parse(arg_0)).result().orElse(null);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        WorldData.a worlddata_a = dynamic.get("spawn").read(WorldData.a.c).result().orElse(WorldData.a.a);
        long j2 = dynamic.get("DayTime").asLong(i2);
        int k2 = LevelVersion.a(dynamic).a();
        int l2 = dynamic.get("clearWeatherTime").asInt(0);
        int i1 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int j1 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        Optional optional = WorldBorder.c.b.parse(dynamic.get("world_border").orElseEmptyMap()).result();
        int k1 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int l1 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream());
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EnderDragonBattle.a.a);
        Logger logger = f;
        Objects.requireNonNull(logger);
        return new WorldDataServer(nbttagcompound, flag, worlddata_a, i2, j2, k2, l2, i1, flag1, j1, flag2, flag3, flag4, optional, k1, l1, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EnderDragonBattle.a.b), worldsettings, worldoptions, worlddataserver_a, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom iregistrycustom, @Nullable NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            nbttagcompound = this.n;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(iregistrycustom, nbttagcompound1, nbttagcompound);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom iregistrycustom, NBTTagCompound nbttagcompound, @Nullable NBTTagCompound nbttagcompound1) {
        nbttagcompound.a("ServerBrands", WorldDataServer.a(this.C));
        nbttagcompound.a("WasModded", this.D);
        if (!this.E.isEmpty()) {
            nbttagcompound.a("removed_features", WorldDataServer.a(this.E));
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().a().b());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().f());
        nbttagcompound2.a("Series", SharedConstants.b().a().c());
        nbttagcompound.a("Version", nbttagcompound2);
        GameProfileSerializer.e(nbttagcompound);
        RegistryOps<NBTBase> dynamicops = iregistrycustom.a(DynamicOpsNBT.a);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : iregistrycustom.f(Registries.by)));
        Logger logger = f;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> nbttagcompound.a(c, (NBTBase)nbtbase));
        nbttagcompound.a("GameType", this.g.b().a());
        nbttagcompound.a("spawn", WorldData.a.c, this.k);
        nbttagcompound.a("Time", this.l);
        nbttagcompound.a("DayTime", this.m);
        nbttagcompound.a("LastPlayed", SystemUtils.e());
        nbttagcompound.a(a, this.g.a());
        nbttagcompound.a("version", 19133);
        nbttagcompound.a("clearWeatherTime", this.p);
        nbttagcompound.a("rainTime", this.r);
        nbttagcompound.a("raining", this.q);
        nbttagcompound.a("thunderTime", this.t);
        nbttagcompound.a("thundering", this.s);
        nbttagcompound.a("hardcore", this.g.c());
        nbttagcompound.a("allowCommands", this.g.e());
        nbttagcompound.a("initialized", this.u);
        this.w.ifPresent(worldborder_c -> nbttagcompound.a("world_border", WorldBorder.c.b, worldborder_c));
        nbttagcompound.a("Difficulty", (byte)this.g.d().a());
        nbttagcompound.a("DifficultyLocked", this.v);
        nbttagcompound.a("GameRules", this.g.f().a());
        nbttagcompound.a("DragonFight", EnderDragonBattle.a.a, this.x);
        if (nbttagcompound1 != null) {
            nbttagcompound.a(b, nbttagcompound1);
        }
        nbttagcompound.a(WorldDataConfiguration.b, this.g.g());
        if (this.y != null) {
            nbttagcompound.a("CustomBossEvents", this.y);
        }
        nbttagcompound.a("ScheduledEvents", this.F.b());
        nbttagcompound.a("WanderingTraderSpawnDelay", this.z);
        nbttagcompound.a("WanderingTraderSpawnChance", this.A);
        nbttagcompound.b("WanderingTraderId", UUIDUtil.a, this.B);
        nbttagcompound.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(nbttagcompound);
    }

    private static NBTTagList a(Set<String> set) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = set.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public WorldData.a a() {
        return this.k;
    }

    @Override
    public long b() {
        return this.l;
    }

    @Override
    public long c() {
        return this.m;
    }

    @Override
    @Nullable
    public NBTTagCompound v() {
        return this.n;
    }

    @Override
    public void a(long i2) {
        this.l = i2;
    }

    @Override
    public void b(long i2) {
        this.m = i2;
    }

    @Override
    public void a(WorldData.a worlddata_a) {
        this.k = worlddata_a;
    }

    @Override
    public String d() {
        return this.g.a();
    }

    @Override
    public int w() {
        return this.o;
    }

    @Override
    public int e() {
        return this.p;
    }

    @Override
    public void a(int i2) {
        this.p = i2;
    }

    @Override
    public boolean f() {
        return this.s;
    }

    @Override
    public void a(boolean flag) {
        if (this.s == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.d());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.s = flag;
    }

    @Override
    public int g() {
        return this.t;
    }

    @Override
    public void b(int i2) {
        this.t = i2;
    }

    @Override
    public boolean h() {
        return this.q;
    }

    @Override
    public void b(boolean flag) {
        if (this.q == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.d());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.q = flag;
    }

    @Override
    public int i() {
        return this.r;
    }

    @Override
    public void c(int i2) {
        this.r = i2;
    }

    @Override
    public EnumGamemode j() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode enumgamemode) {
        this.g = this.g.a(enumgamemode);
    }

    @Override
    public boolean k() {
        return this.g.c();
    }

    @Override
    public boolean l() {
        return this.g.e();
    }

    @Override
    public boolean m() {
        return this.u;
    }

    @Override
    public void c(boolean flag) {
        this.u = flag;
    }

    @Override
    public GameRules n() {
        return this.g.f();
    }

    @Override
    public Optional<WorldBorder.c> o() {
        return this.w;
    }

    @Override
    public void a(Optional<WorldBorder.c> optional) {
        this.w = optional;
    }

    @Override
    public EnumDifficulty p() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty enumdifficulty) {
        this.g = this.g.a(enumdifficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.p(), this.q());
        for (EntityPlayer player : this.world.C()) {
            player.g.b(packet);
        }
    }

    @Override
    public boolean q() {
        return this.v;
    }

    @Override
    public void d(boolean flag) {
        this.v = flag;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> r() {
        return this.F;
    }

    @Override
    public void a(CrashReportSystemDetails crashreportsystemdetails, LevelHeightAccessor levelheightaccessor) {
        IWorldDataServer.super.a(crashreportsystemdetails, levelheightaccessor);
        SaveData.super.a(crashreportsystemdetails);
    }

    @Override
    public WorldOptions x() {
        return this.h;
    }

    @Override
    public boolean y() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean z() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle A() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a B() {
        return this.x;
    }

    @Override
    public void a(EnderDragonBattle.a enderdragonbattle_a) {
        this.x = enderdragonbattle_a;
    }

    @Override
    public WorldDataConfiguration C() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration worlddataconfiguration) {
        this.g = this.g.a(worlddataconfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound D() {
        return this.y;
    }

    @Override
    public void a(@Nullable NBTTagCompound nbttagcompound) {
        this.y = nbttagcompound;
    }

    @Override
    public int s() {
        return this.z;
    }

    @Override
    public void d(int i2) {
        this.z = i2;
    }

    @Override
    public int t() {
        return this.A;
    }

    @Override
    public void e(int i2) {
        this.A = i2;
    }

    @Override
    @Nullable
    public UUID u() {
        return this.B;
    }

    @Override
    public void a(UUID uuid) {
        this.B = uuid;
    }

    @Override
    public void a(String s2, boolean flag) {
        this.C.add(s2);
        this.D |= flag;
    }

    @Override
    public boolean E() {
        return this.D;
    }

    @Override
    public Set<String> F() {
        return ImmutableSet.copyOf(this.C);
    }

    @Override
    public Set<String> G() {
        return Set.copyOf(this.E);
    }

    @Override
    public IWorldDataServer H() {
        return this;
    }

    @Override
    public WorldSettings I() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

