/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class IntRange {
    private static final Codec<IntRange> b = RecordCodecBuilder.create(var02 -> var02.group((App)NumberProviders.a.optionalFieldOf("min").forGetter(var0 -> Optional.ofNullable(var0.c)), (App)NumberProviders.a.optionalFieldOf("max").forGetter(var0 -> Optional.ofNullable(var0.d))).apply((Applicative)var02, IntRange::new));
    public static final Codec<IntRange> a = Codec.either((Codec)Codec.INT, b).xmap(var0 -> (IntRange)var0.map(IntRange::a, Function.identity()), var0 -> {
        OptionalInt var1 = var0.b();
        if (var1.isPresent()) {
            return Either.left((Object)var1.getAsInt());
        }
        return Either.right((Object)var0);
    });
    @Nullable
    private final NumberProvider c;
    @Nullable
    private final NumberProvider d;
    private final b e;
    private final a f;

    public Set<ContextKey<?>> a() {
        ImmutableSet.Builder var0 = ImmutableSet.builder();
        if (this.c != null) {
            var0.addAll(this.c.a());
        }
        if (this.d != null) {
            var0.addAll(this.d.a());
        }
        return var0.build();
    }

    private IntRange(Optional<NumberProvider> var0, Optional<NumberProvider> var1) {
        this((NumberProvider)var0.orElse(null), (NumberProvider)var1.orElse(null));
    }

    private IntRange(@Nullable NumberProvider var02, @Nullable NumberProvider var12) {
        this.c = var02;
        this.d = var12;
        if (var02 == null) {
            if (var12 == null) {
                this.e = (var0, var1) -> var1;
                this.f = (var0, var1) -> true;
            } else {
                this.e = (var1, var2) -> Math.min(var12.a(var1), var2);
                this.f = (var1, var2) -> var2 <= var12.a(var1);
            }
        } else if (var12 == null) {
            this.e = (var1, var2) -> Math.max(var02.a(var1), var2);
            this.f = (var1, var2) -> var2 >= var02.a(var1);
        } else {
            this.e = (var2, var3) -> MathHelper.a(var3, var02.a(var2), var12.a(var2));
            this.f = (var2, var3) -> var3 >= var02.a(var2) && var3 <= var12.a(var2);
        }
    }

    public static IntRange a(int var0) {
        ConstantValue var1 = ConstantValue.a(var0);
        return new IntRange(Optional.of(var1), Optional.of(var1));
    }

    public static IntRange a(int var0, int var1) {
        return new IntRange(Optional.of(ConstantValue.a(var0)), Optional.of(ConstantValue.a(var1)));
    }

    public static IntRange b(int var0) {
        return new IntRange(Optional.of(ConstantValue.a(var0)), Optional.empty());
    }

    public static IntRange c(int var0) {
        return new IntRange(Optional.empty(), Optional.of(ConstantValue.a(var0)));
    }

    public int a(LootTableInfo var0, int var1) {
        return this.e.apply(var0, var1);
    }

    public boolean b(LootTableInfo var0, int var1) {
        return this.f.test(var0, var1);
    }

    private OptionalInt b() {
        ConstantValue var0;
        NumberProvider numberProvider;
        if (Objects.equals(this.c, this.d) && (numberProvider = this.c) instanceof ConstantValue && Math.floor((var0 = (ConstantValue)numberProvider).c()) == (double)var0.c()) {
            return OptionalInt.of((int)var0.c());
        }
        return OptionalInt.empty();
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }
}

