/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBed;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBell;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftComparator;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndPortal;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftMovingPiston;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSuspiciousSand;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTestBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTestInstance;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftVault;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
            if (tileEntity != null) {
                return new CraftBlockEntityState<TileEntity>(world, tileEntity);
            }
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftBlockType.minecraftToBukkit(blockData.b()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends TileEntity, B extends CraftBlockEntityState<T>> void register(Material blockType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor) {
        CraftBlockStates.register(Collections.singletonList(blockType), blockStateType, blockStateConstructor, tileEntityConstructor);
    }

    private static <T extends TileEntity, B extends CraftBlockEntityState<T>> void register(List<Material> blockTypes, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor) {
        BlockEntityStateFactory<T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, tileEntityConstructor);
        for (Material blockType : blockTypes) {
            CraftBlockStates.register(blockType, factory);
        }
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static TileEntity createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(BlockPosition.c, CraftBlockType.bukkitToMinecraft(material).m());
        }
        return null;
    }

    public static BlockState getBlockState(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockPosition blockPosition = craftBlock.getPosition();
        IBlockData blockData = craftBlock.getNMS();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
        blockState.setWorldHandle(craftBlock.getHandle());
        return blockState;
    }

    @Deprecated
    public static BlockState getBlockState(BlockPosition blockPosition, Material material, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(IWorldReader world, BlockPosition blockPosition, Material material, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(world.L_(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(IRegistryCustom registry, BlockPosition blockPosition, Material material, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        IBlockData blockData = CraftBlockType.bukkitToMinecraft(material).m();
        return CraftBlockStates.getBlockState(registry, blockPosition, blockData, blockEntityTag);
    }

    @Deprecated
    public static BlockState getBlockState(IBlockData blockData, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), BlockPosition.c, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(IWorldReader world, BlockPosition blockPosition, IBlockData blockData, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(world.L_(), blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(IRegistryCustom registry, BlockPosition blockPosition, IBlockData blockData, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        TileEntity tileEntity = blockEntityTag == null ? null : TileEntity.a(blockPosition, blockData, blockEntityTag, registry);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    private static CraftBlockState getBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
        Material material = CraftBlockType.minecraftToBukkit(blockData.b());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material);
        return factory.createBlockState(world, blockPosition, blockData, tileEntity);
    }

    public static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(GeneratorAccess world, BlockPosition pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    public static CraftBlockState getBlockState(GeneratorAccess world, BlockPosition pos, int flag) {
        return new CraftBlockState(CraftBlock.at(world, pos), flag);
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BAMBOO_SIGN, Material.BAMBOO_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CHERRY_SIGN, Material.CHERRY_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.MANGROVE_SIGN, Material.MANGROVE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.PALE_OAK_SIGN, Material.PALE_OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN), CraftSign.class, CraftSign::new, TileEntitySign::new);
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_HANGING_SIGN, Material.ACACIA_WALL_HANGING_SIGN, Material.BAMBOO_HANGING_SIGN, Material.BAMBOO_WALL_HANGING_SIGN, Material.BIRCH_HANGING_SIGN, Material.BIRCH_WALL_HANGING_SIGN, Material.CHERRY_HANGING_SIGN, Material.CHERRY_WALL_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN, Material.CRIMSON_WALL_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.DARK_OAK_WALL_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN, Material.JUNGLE_WALL_HANGING_SIGN, Material.MANGROVE_HANGING_SIGN, Material.MANGROVE_WALL_HANGING_SIGN, Material.OAK_HANGING_SIGN, Material.OAK_WALL_HANGING_SIGN, Material.PALE_OAK_HANGING_SIGN, Material.PALE_OAK_WALL_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN, Material.SPRUCE_WALL_HANGING_SIGN, Material.WARPED_HANGING_SIGN, Material.WARPED_WALL_HANGING_SIGN), CraftHangingSign.class, CraftHangingSign::new, HangingSignBlockEntity::new);
        CraftBlockStates.register(Arrays.asList(Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD), CraftSkull.class, CraftSkull::new, TileEntitySkull::new);
        CraftBlockStates.register(Arrays.asList(Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK), CraftCommandBlock.class, CraftCommandBlock::new, TileEntityCommand::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BANNER, Material.BLACK_WALL_BANNER, Material.BLUE_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_BANNER, Material.BROWN_WALL_BANNER, Material.CYAN_BANNER, Material.CYAN_WALL_BANNER, Material.GRAY_BANNER, Material.GRAY_WALL_BANNER, Material.GREEN_BANNER, Material.GREEN_WALL_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.LIME_BANNER, Material.LIME_WALL_BANNER, Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER, Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER, Material.PINK_BANNER, Material.PINK_WALL_BANNER, Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER, Material.RED_BANNER, Material.RED_WALL_BANNER, Material.WHITE_BANNER, Material.WHITE_WALL_BANNER, Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER), CraftBanner.class, CraftBanner::new, TileEntityBanner::new);
        CraftBlockStates.register(Arrays.asList(Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX), CraftShulkerBox.class, CraftShulkerBox::new, TileEntityShulkerBox::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BED, Material.BLUE_BED, Material.BROWN_BED, Material.CYAN_BED, Material.GRAY_BED, Material.GREEN_BED, Material.LIGHT_BLUE_BED, Material.LIGHT_GRAY_BED, Material.LIME_BED, Material.MAGENTA_BED, Material.ORANGE_BED, Material.PINK_BED, Material.PURPLE_BED, Material.RED_BED, Material.WHITE_BED, Material.YELLOW_BED), CraftBed.class, CraftBed::new, TileEntityBed::new);
        CraftBlockStates.register(Arrays.asList(Material.BEEHIVE, Material.BEE_NEST), CraftBeehive.class, CraftBeehive::new, TileEntityBeehive::new);
        CraftBlockStates.register(Arrays.asList(Material.CAMPFIRE, Material.SOUL_CAMPFIRE), CraftCampfire.class, CraftCampfire::new, TileEntityCampfire::new);
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_SHELF, Material.BAMBOO_SHELF, Material.BIRCH_SHELF, Material.CHERRY_SHELF, Material.CRIMSON_SHELF, Material.DARK_OAK_SHELF, Material.JUNGLE_SHELF, Material.MANGROVE_SHELF, Material.OAK_SHELF, Material.PALE_OAK_SHELF, Material.SPRUCE_SHELF, Material.WARPED_SHELF), CraftShelf.class, CraftShelf::new, ShelfBlockEntity::new);
        CraftBlockStates.register(Arrays.asList(Material.COPPER_GOLEM_STATUE, Material.EXPOSED_COPPER_GOLEM_STATUE, Material.WEATHERED_COPPER_GOLEM_STATUE, Material.OXIDIZED_COPPER_GOLEM_STATUE, Material.WAXED_COPPER_GOLEM_STATUE, Material.WAXED_EXPOSED_COPPER_GOLEM_STATUE, Material.WAXED_WEATHERED_COPPER_GOLEM_STATUE, Material.WAXED_OXIDIZED_COPPER_GOLEM_STATUE), CraftCopperGolemStatue.class, CraftCopperGolemStatue::new, CopperGolemStatueBlockEntity::new);
        CraftBlockStates.register(Material.BARREL, CraftBarrel.class, CraftBarrel::new, TileEntityBarrel::new);
        CraftBlockStates.register(Material.BEACON, CraftBeacon.class, CraftBeacon::new, TileEntityBeacon::new);
        CraftBlockStates.register(Material.BELL, CraftBell.class, CraftBell::new, TileEntityBell::new);
        CraftBlockStates.register(Material.BLAST_FURNACE, CraftBlastFurnace.class, CraftBlastFurnace::new, TileEntityBlastFurnace::new);
        CraftBlockStates.register(Material.BREWING_STAND, CraftBrewingStand.class, CraftBrewingStand::new, TileEntityBrewingStand::new);
        CraftBlockStates.register(Arrays.asList(Material.CHEST, Material.COPPER_CHEST, Material.EXPOSED_COPPER_CHEST, Material.WEATHERED_COPPER_CHEST, Material.OXIDIZED_COPPER_CHEST, Material.WAXED_COPPER_CHEST, Material.WAXED_EXPOSED_COPPER_CHEST, Material.WAXED_WEATHERED_COPPER_CHEST, Material.WAXED_OXIDIZED_COPPER_CHEST), CraftChest.class, CraftChest::new, TileEntityChest::new);
        CraftBlockStates.register(Material.CHISELED_BOOKSHELF, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new, ChiseledBookShelfBlockEntity::new);
        CraftBlockStates.register(Material.COMPARATOR, CraftComparator.class, CraftComparator::new, TileEntityComparator::new);
        CraftBlockStates.register(Material.CONDUIT, CraftConduit.class, CraftConduit::new, TileEntityConduit::new);
        CraftBlockStates.register(Material.CREAKING_HEART, CraftCreakingHeart.class, CraftCreakingHeart::new, CreakingHeartBlockEntity::new);
        CraftBlockStates.register(Material.DAYLIGHT_DETECTOR, CraftDaylightDetector.class, CraftDaylightDetector::new, TileEntityLightDetector::new);
        CraftBlockStates.register(Material.DECORATED_POT, CraftDecoratedPot.class, CraftDecoratedPot::new, DecoratedPotBlockEntity::new);
        CraftBlockStates.register(Material.DISPENSER, CraftDispenser.class, CraftDispenser::new, TileEntityDispenser::new);
        CraftBlockStates.register(Material.DROPPER, CraftDropper.class, CraftDropper::new, TileEntityDropper::new);
        CraftBlockStates.register(Material.ENCHANTING_TABLE, CraftEnchantingTable.class, CraftEnchantingTable::new, TileEntityEnchantTable::new);
        CraftBlockStates.register(Material.ENDER_CHEST, CraftEnderChest.class, CraftEnderChest::new, TileEntityEnderChest::new);
        CraftBlockStates.register(Material.END_GATEWAY, CraftEndGateway.class, CraftEndGateway::new, TileEntityEndGateway::new);
        CraftBlockStates.register(Material.END_PORTAL, CraftEndPortal.class, CraftEndPortal::new, TileEntityEnderPortal::new);
        CraftBlockStates.register(Material.FURNACE, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new, TileEntityFurnaceFurnace::new);
        CraftBlockStates.register(Material.HOPPER, CraftHopper.class, CraftHopper::new, TileEntityHopper::new);
        CraftBlockStates.register(Material.JIGSAW, CraftJigsaw.class, CraftJigsaw::new, TileEntityJigsaw::new);
        CraftBlockStates.register(Material.JUKEBOX, CraftJukebox.class, CraftJukebox::new, TileEntityJukeBox::new);
        CraftBlockStates.register(Material.LECTERN, CraftLectern.class, CraftLectern::new, TileEntityLectern::new);
        CraftBlockStates.register(Material.MOVING_PISTON, CraftMovingPiston.class, CraftMovingPiston::new, TileEntityPiston::new);
        CraftBlockStates.register(Material.SCULK_CATALYST, CraftSculkCatalyst.class, CraftSculkCatalyst::new, SculkCatalystBlockEntity::new);
        CraftBlockStates.register(Material.CALIBRATED_SCULK_SENSOR, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new, CalibratedSculkSensorBlockEntity::new);
        CraftBlockStates.register(Material.SCULK_SENSOR, CraftSculkSensor.class, CraftSculkSensor::new, SculkSensorBlockEntity::new);
        CraftBlockStates.register(Material.SCULK_SHRIEKER, CraftSculkShrieker.class, CraftSculkShrieker::new, SculkShriekerBlockEntity::new);
        CraftBlockStates.register(Material.SMOKER, CraftSmoker.class, CraftSmoker::new, TileEntitySmoker::new);
        CraftBlockStates.register(Material.SPAWNER, CraftCreatureSpawner.class, CraftCreatureSpawner::new, TileEntityMobSpawner::new);
        CraftBlockStates.register(Material.STRUCTURE_BLOCK, CraftStructureBlock.class, CraftStructureBlock::new, TileEntityStructure::new);
        CraftBlockStates.register(Material.SUSPICIOUS_SAND, CraftSuspiciousSand.class, CraftSuspiciousSand::new, BrushableBlockEntity::new);
        CraftBlockStates.register(Material.SUSPICIOUS_GRAVEL, CraftBrushableBlock.class, CraftBrushableBlock::new, BrushableBlockEntity::new);
        CraftBlockStates.register(Material.TRAPPED_CHEST, CraftChest.class, CraftChest::new, TileEntityChestTrapped::new);
        CraftBlockStates.register(Material.CRAFTER, CraftCrafter.class, CraftCrafter::new, CrafterBlockEntity::new);
        CraftBlockStates.register(Material.TRIAL_SPAWNER, CraftTrialSpawner.class, CraftTrialSpawner::new, TrialSpawnerBlockEntity::new);
        CraftBlockStates.register(Material.VAULT, CraftVault.class, CraftVault::new, VaultBlockEntity::new);
        CraftBlockStates.register(Material.TEST_BLOCK, CraftTestBlock.class, CraftTestBlock::new, TestBlockEntity::new);
        CraftBlockStates.register(Material.TEST_INSTANCE_BLOCK, CraftTestInstance.class, CraftTestInstance::new, TestInstanceBlockEntity::new);
    }

    private static class BlockEntityStateFactory<T extends TileEntity, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
        }

        @Override
        public final B createBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(BlockPosition blockPosition, IBlockData blockData) {
            return (T)((TileEntity)this.tileEntityConstructor.apply(blockPosition, blockData));
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, BlockPosition var2, IBlockData var3, TileEntity var4);
    }
}

