/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryAbstractHorse;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, EntityHorseAbstract entity) {
        super(server, entity);
    }

    @Override
    public EntityHorseAbstract getHandle() {
        return (EntityHorseAbstract)this.entity;
    }

    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getDomestication() {
        return this.getHandle().he();
    }

    public void setDomestication(int value) {
        Preconditions.checkArgument((value >= 0 && value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication level (%s) need to be between %s and %s (max domestication)", (Object)value, (Object)0, (Object)this.getMaxDomestication());
        this.getHandle().t(value);
    }

    public int getMaxDomestication() {
        return this.getHandle().hj();
    }

    public void setMaxDomestication(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Max domestication (%s) cannot be zero or less", (int)value);
        this.getHandle().maxDomestication = value;
    }

    public double getJumpStrength() {
        return this.getHandle().i(GenericAttributes.p);
    }

    public void setJumpStrength(double strength) {
        Preconditions.checkArgument((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength (%s) cannot be less than zero", (Object)strength);
        this.getHandle().h(GenericAttributes.p).a(strength);
    }

    public boolean isTamed() {
        return this.getHandle().gZ();
    }

    public void setTamed(boolean tamed) {
        this.getHandle().y(tamed);
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUUID() {
        EntityReference<EntityLiving> owner = this.getHandle().d();
        return owner != null ? owner.c() : null;
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().dl = uuid != null ? EntityReference.a(uuid) : null;
    }

    public boolean isEatingHaystack() {
        return this.getHandle().hb();
    }

    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().A(eatingHaystack);
    }

    public AbstractHorseInventory getInventory() {
        return new CraftInventoryAbstractHorse(this.getHandle().cK, this.getHandle().bZ);
    }
}

